/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.emf.ui.forms;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.statet.ecommons.emf.ui.forms.EFLayoutUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class MasterDetailComposite
extends SashForm {
    private final Composite master;
    private final Composite detail;
    private boolean checkLayout;
    private final Set<Sash> sashes = new HashSet<Sash>();
    private final IManagedForm form;

    public MasterDetailComposite(Composite parent, IManagedForm managedForm) {
        super(parent, 256);
        this.form = managedForm;
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.adapt((Control)this, false, false);
        this.master = toolkit.createComposite((Composite)this);
        this.master.setLayout(EFLayoutUtil.createMainSashLeftLayout(1));
        this.detail = toolkit.createComposite((Composite)this);
        this.detail.setLayout(EFLayoutUtil.createMainSashRightLayout(1));
        this.setWeights(new int[]{40, 60});
        this.checkLayout = true;
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                MasterDetailComposite.this.checkSashes();
            }
        };
        this.master.addListener(11, listener);
        this.detail.addListener(11, listener);
    }

    public Composite getMasterContainer() {
        return this.master;
    }

    public Composite getDetailContainer() {
        return this.detail;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.checkLayout) {
            this.checkChildren();
        }
        return super.computeSize(wHint, hHint, changed);
    }

    public void layout(boolean changed, boolean all) {
        if (this.checkLayout) {
            this.checkChildren();
        }
        super.layout(changed, all);
    }

    public void layout(Control[] changed, int flags) {
        if (this.checkLayout) {
            this.checkChildren();
        }
        super.layout(changed, flags);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.checkLayout) {
            this.checkChildren();
        }
        super.setBounds(x, y, width, height);
    }

    public void checkChildren() {
        this.checkLayout = false;
        Control[] children = this.master.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getLayoutData() == null) {
                children[i].setLayoutData((Object)new GridData(4, 4, true, true));
            }
            ++i;
        }
        children = this.detail.getChildren();
        i = 0;
        while (i < children.length) {
            if (children[i].getLayoutData() == null) {
                children[i].setLayoutData((Object)new TableWrapData(256, 128));
            }
            ++i;
        }
    }

    private void checkSashes() {
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Sash sash;
            Control control = children[i];
            if (control instanceof Sash && !this.sashes.contains(sash = (Sash)control)) {
                new SashListener(sash);
                this.sashes.add(sash);
            }
            ++i;
        }
    }

    private class SashListener
    implements Listener {
        private boolean hover;

        public SashListener(Sash sash) {
            sash.addListener(6, (Listener)this);
            sash.addListener(7, (Listener)this);
            sash.addListener(9, (Listener)this);
            sash.addListener(12, (Listener)this);
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 6: {
                    this.hover = true;
                    ((Sash)event.widget).redraw();
                    break;
                }
                case 7: {
                    this.hover = false;
                    ((Sash)event.widget).redraw();
                    break;
                }
                case 9: {
                    this.paintSash(event);
                    break;
                }
                case 12: {
                    MasterDetailComposite.this.sashes.remove(event.widget);
                }
            }
        }

        private void paintSash(Event event) {
            Sash sash = (Sash)event.widget;
            IManagedForm form = MasterDetailComposite.this.form;
            FormColors colors = form.getToolkit().getColors();
            GC gc = event.gc;
            gc.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
            gc.setForeground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
            Point size = sash.getSize();
            if ((sash.getStyle() & 0x200) != 0) {
                if (this.hover) {
                    gc.fillRectangle(0, 0, size.x, size.y);
                }
            } else if (this.hover) {
                gc.fillRectangle(0, 0, size.x, size.y);
            }
        }
    }
}

