/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.doc;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.dsl.dcf.core.source.DcfLexer;
import org.eclipse.statet.ecommons.text.core.input.DocumentParserInput;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScan;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitioner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.WrappedPartitionNodeScan;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.core.model.RPkgDescrFieldDefinition;
import org.eclipse.statet.r.core.model.RPkgDescriptions;
import org.eclipse.statet.r.core.source.doc.RChunkPartitionNodeScanner;
import org.eclipse.statet.r.core.source.doc.RPkgDescrPartitionNodeType;

@NonNullByDefault
public class RPkgDescrPartitionNodeScanner
implements TreePartitionNodeScanner {
    private final DcfLexer lexer;
    private TreePartitionNodeScan scan;
    private TreePartitionNode rootNode;
    private TreePartitionNode node;
    private RPkgDescrPartitionNodeType type;
    private final RChunkPartitionNodeScanner rScanner = new RChunkPartitionNodeScanner();
    private WrappedPartitionNodeScan rScan;
    private int rStartOffset;
    private @Nullable TreePartitionNode rStartNode;

    /*
     * Unable to fully structure code
     */
    public static final @Nullable TreePartitionNode findDcfRootNode(@Nullable TreePartitionNode node) {
        while (true) {
            if (node == null) {
                return null;
            }
            if (node.getType() instanceof RPkgDescrPartitionNodeType) ** GOTO lbl8
            node = node.getParent();
        }
lbl-1000:
        // 1 sources

        {
            node = parentNode;
lbl8:
            // 2 sources

            ** while ((parentNode = node.getParent()) != null && parentNode.getType() instanceof RPkgDescrPartitionNodeType)
        }
lbl9:
        // 1 sources

        return node;
    }

    public RPkgDescrPartitionNodeScanner() {
        this.lexer = new DcfLexer();
    }

    public RPkgDescrPartitionNodeType getDefaultRootType() {
        return RPkgDescrPartitionNodeType.DEFAULT_ROOT;
    }

    public void checkRestartState(TreePartitionNodeScan.State state, IDocument document, TreePartitioner partitioner) throws BadLocationException {
        RPkgDescrPartitionNodeType rootType = this.getDefaultRootType();
        TreePartitionNode node = state.node;
        int offset = state.offset;
        while (node.getType() != rootType) {
            offset = node.getStartOffset();
            node = node.getParent();
        }
        state.offset = offset;
        state.node = node;
    }

    public void execute(TreePartitionNodeScan scan) {
        this.scan = scan;
        this.node = null;
        this.rScan = new WrappedPartitionNodeScan(scan);
        this.setRange(scan.getStartOffset(), scan.getEndOffset());
        this.init();
        assert (this.rootNode != null && this.node != null);
        this.process();
        this.rScan = null;
    }

    protected TreePartitionNodeScan getScan() {
        return this.scan;
    }

    protected void setRange(int startOffset, int endOffset) {
        DocumentParserInput input = new DocumentParserInput(this.getScan().getDocument());
        this.lexer.reset(input.init(startOffset, endOffset));
    }

    protected void init() {
        TreePartitionNode beginNode = this.getScan().getBeginNode();
        if (beginNode.getType() instanceof RPkgDescrPartitionNodeType) {
            this.initNode(beginNode, (RPkgDescrPartitionNodeType)beginNode.getType());
        } else {
            this.node = beginNode;
            this.addNode(this.getDefaultRootType(), this.getScan().getStartOffset());
            this.rootNode = this.node;
        }
        this.rStartNode = null;
    }

    protected final void initNode(TreePartitionNode node, RPkgDescrPartitionNodeType type) {
        if (ObjectUtils.isNonNull((Object)this.node)) {
            throw new IllegalStateException();
        }
        this.node = node;
        this.type = type;
        this.rootNode = (TreePartitionNode)ObjectUtils.nonNullAssert((Object)RPkgDescrPartitionNodeScanner.findDcfRootNode(node));
    }

    protected final void addNode(RPkgDescrPartitionNodeType type, int offset) {
        this.node = this.scan.add((TreePartitionNodeType)type, this.node, offset, 0);
        this.type = type;
    }

    protected final void addNode(TreePartitionNodeType type, RPkgDescrPartitionNodeType descrType, int offset) {
        this.node = this.scan.add(type, this.node, offset, 0);
        this.type = descrType;
    }

    protected final TreePartitionNode getNode() {
        return this.node;
    }

    protected final void exitNode(int offset, int flags) {
        this.scan.expand(this.node, offset, flags, true);
        this.node = this.node.getParent();
        this.type = (RPkgDescrPartitionNodeType)this.node.getType();
    }

    private void process() {
        int valueEndOffset = -1;
        block10: while (true) {
            byte type = this.lexer.next();
            switch (type) {
                case 3: 
                case 5: 
                case 6: {
                    continue block10;
                }
                case 1: {
                    valueEndOffset = this.lexer.getOffset();
                    continue block10;
                }
                case -1: {
                    valueEndOffset = this.lexer.getOffset();
                }
            }
            if (this.rStartNode != null) {
                this.scanRValue(valueEndOffset);
                this.exitNode(valueEndOffset, 0);
            }
            switch (type) {
                case -1: {
                    this.handleEOF(this.type);
                    return;
                }
                case 4: {
                    this.addNode(RPkgDescrPartitionNodeType.FIELD_NAME, this.lexer.getOffset());
                    this.exitNode(this.lexer.getEndOffset(), 0);
                    if (!this.isRField(this.lexer.getText())) continue block10;
                    assert (this.rStartNode == null);
                    this.rStartOffset = valueEndOffset = this.lexer.getEndOffset();
                    this.addNode((TreePartitionNodeType)this.rScanner.getDefaultRootType(), RPkgDescrPartitionNodeType.FIELD_VALUE_R, valueEndOffset);
                    this.rStartNode = this.getNode();
                    continue block10;
                }
                case 2: {
                    int endIdx = this.isPotentialFieldName(this.lexer.getText());
                    if (endIdx < 0) continue block10;
                    this.addNode(RPkgDescrPartitionNodeType.FIELD_NAME, this.lexer.getOffset());
                    this.exitNode(this.lexer.getOffset() + endIdx, 256);
                    continue block10;
                }
            }
        }
    }

    protected void scanRValue(int endOffset) {
        TreePartitionNode node = (TreePartitionNode)ObjectUtils.nonNullAssert((Object)this.rStartNode);
        this.rStartNode = null;
        this.rScan.init(this.rStartOffset, endOffset, node);
        this.rScanner.execute((TreePartitionNodeScan)this.rScan);
        this.rScan.exit();
    }

    protected void handleEOF(RPkgDescrPartitionNodeType type) {
        this.scan.expand(this.node, this.scan.getEndOffset(), 0, true);
    }

    private int isPotentialFieldName(@Nullable String s) {
        if (s == null) {
            return -1;
        }
        int idx = 0;
        block4: while (idx < s.length()) {
            switch (s.charAt(idx)) {
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    break;
                }
                case ' ': {
                    break block4;
                }
                default: {
                    return -1;
                }
            }
            ++idx;
        }
        return idx;
    }

    protected boolean isRField(@Nullable String name) {
        if (name != null) {
            RPkgDescrFieldDefinition fieldDef = RPkgDescriptions.getFieldDefinition(name);
            return fieldDef != null && fieldDef.getDataType() == 10;
        }
        return false;
    }
}

