/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.builder.RPkgData;
import org.eclipse.statet.internal.r.core.model.rpkg.RPkgDescrReconciler;
import org.eclipse.statet.internal.r.core.rmodel.RModelManagerImpl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.StatusCodes;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.eclipse.statet.ltk.model.core.build.SourceUnitIssueSupport;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.model.RPkgDescriptions;
import org.eclipse.statet.r.core.model.build.RPkgDescrSourceUnitModelContainer;
import org.eclipse.statet.r.core.model.rpkg.RPkgDescrField;
import org.eclipse.statet.r.core.model.rpkg.RPkgDescrSourceStructElement;
import org.eclipse.statet.r.core.model.rpkg.RPkgDescrSourceUnitModelInfo;
import org.eclipse.statet.r.core.project.RBuildpaths;

@NonNullByDefault
public class RPkgReconciler {
    private final SourceUnitManager sourceUnitManager = LtkModels.getSourceUnitManager();
    private final RModelManagerImpl manager;
    private @Nullable RPkgDescrReconciler rPkgDescrReconciler;

    public RPkgReconciler(RModelManagerImpl manager) {
        this.manager = manager;
    }

    protected synchronized RPkgDescrReconciler getRPkgDescrReconciler() {
        RPkgDescrReconciler reconciler = this.rPkgDescrReconciler;
        if (reconciler == null) {
            this.rPkgDescrReconciler = reconciler = new RPkgDescrReconciler(this.manager);
        }
        return reconciler;
    }

    public RPkgData parsePkgData(IContainer pkgRoot, MultiStatus status, SubMonitor m) {
        RPkgData result;
        block12: {
            result = new RPkgData();
            try {
                IProject project = pkgRoot.getProject();
                if (!pkgRoot.exists()) {
                    project.createMarker("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", Map.of("severity", 2, "message", NLS.bind((String)"R package folder ''{0}'' is missing.", (Object)pkgRoot.getProjectRelativePath()), "location", "R Project Configuration"));
                    return result;
                }
                IFile file = pkgRoot.getFile(RBuildpaths.PKG_DESCRIPTION_FILE_PATH);
                if (file.exists()) {
                    SourceUnit sourceUnit = this.sourceUnitManager.getSourceUnit("RPkg.Descr", Ltk.PERSISTENCE_CONTEXT, (Object)file, (IProgressMonitor)m);
                    try {
                        RPkgDescrSourceUnitModelContainer adapter = (RPkgDescrSourceUnitModelContainer)((Object)sourceUnit.getAdapter(RPkgDescrSourceUnitModelContainer.class));
                        if (adapter != null) {
                            RPkgDescrField field;
                            RPkgDescrSourceUnitModelInfo model;
                            SourceUnitIssueSupport issueSupport = adapter.getIssueSupport();
                            if (issueSupport != null) {
                                issueSupport.clearIssues(adapter.getSourceUnit());
                            }
                            if ((model = this.getRPkgDescrReconciler().reconcile(adapter, 0x2000002, (IProgressMonitor)m)) != null && (field = (RPkgDescrField)model.getField(RPkgDescriptions.Package_FIELD)) != null && !StatusCodes.isError((int)((RPkgDescrSourceStructElement)((Object)field)).getModelStatusCode())) {
                                result.setPkgName((String)ObjectUtils.nonNullAssert((Object)field.getValueText()));
                            }
                        }
                    }
                    finally {
                        sourceUnit.disconnect((IProgressMonitor)m);
                    }
                    if (result.getPkgName() == null) {
                        pkgRoot.createMarker("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", Map.of("severity", 2, "message", "'DESCRIPTION' file for R package is incomplete."));
                    }
                    break block12;
                }
                pkgRoot.createMarker("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", Map.of("severity", 2, "message", "'DESCRIPTION' file for R package is missing."));
                return result;
            }
            catch (CoreException | StatusException e) {
                status.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)"An error occurred when parsing R package ''DESCRIPTION'' file ''{0}''.", (Object)pkgRoot.getFullPath().toString()), e));
            }
        }
        return result;
    }
}

