/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.project.RProjects;

@NonNullByDefault
public class WorkspaceAdapterFactory
implements IAdapterFactory {
    private static final @NonNull Class<?>[] ADAPTERS = new Class[]{RCoreAccess.class};

    public static RCoreAccess getResourceCoreAccess(IResource resource) {
        RProject rProject = RProjects.getRProject(resource.getProject());
        if (rProject != null) {
            return rProject;
        }
        return RCore.getWorkbenchAccess();
    }

    public static @Nullable RCoreAccess getResourceCoreAccess(@Nullable Object resource) {
        if (resource instanceof IResource) {
            return WorkspaceAdapterFactory.getResourceCoreAccess((IResource)resource);
        }
        return null;
    }

    public @NonNull Class<?>[] getAdapterList() {
        return ADAPTERS;
    }

    public <T> @Nullable T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == RCoreAccess.class) {
            if (adaptableObject instanceof WorkspaceSourceUnit) {
                return (T)WorkspaceAdapterFactory.getResourceCoreAccess(((WorkspaceSourceUnit)adaptableObject).getResource());
            }
            if (adaptableObject instanceof IResource) {
                return (T)WorkspaceAdapterFactory.getResourceCoreAccess((IResource)adaptableObject);
            }
            return (T)RCore.getWorkbenchAccess();
        }
        return null;
    }
}

