/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import org.eclipse.statet.jcommons.collections.IntMap;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class IntArrayMap<V>
implements IntMap<V> {
    private @Nullable Object[] array;
    private int size;

    public IntArrayMap() {
        this.array = new Object[16];
    }

    public IntArrayMap(int initialCapacity) {
        this.array = new Object[initialCapacity];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(int key) {
        return key < this.array.length && this.array[key] != null;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return key instanceof Integer && this.containsKey((Integer)key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        if (value != null) {
            int i = 0;
            while (i < this.array.length) {
                if (this.array[i] != null && value.equals(this.array[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public @Nullable V get(int key) {
        if (key < this.array.length) {
            return (V)this.array[key];
        }
        return null;
    }

    @Override
    public @Nullable V get(@Nullable Object key) {
        return key instanceof Integer ? (V)this.get((Integer)key) : null;
    }

    private void increase(int min) {
        Object[] newArray = new Object[min + 16];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        this.array = newArray;
    }

    @Override
    public @Nullable V put(int key, V value) {
        if (key >= this.array.length) {
            this.increase(key);
        }
        Object oldValue = this.array[key];
        this.array[key] = value;
        if (oldValue != null) {
            return (V)oldValue;
        }
        ++this.size;
        return null;
    }

    @Override
    public V computeIfAbsent(int key, IntFunction<V> mappingFunction) {
        Object value;
        if (key >= this.array.length) {
            this.increase(key);
        }
        if ((value = this.array[key]) == null) {
            this.array[key] = value = mappingFunction.apply(key);
            ++this.size;
        }
        return (V)value;
    }

    @Override
    public @Nullable V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> t) {
        for (Map.Entry<Integer, V> entry : t.entrySet()) {
            this.put((int)entry.getKey(), entry.getValue());
        }
    }

    public @Nullable V remove(int key) {
        Object oldValue;
        if (key < this.array.length && (oldValue = this.array[key]) != null) {
            this.array[key] = null;
            --this.size;
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public @Nullable V remove(@Nullable Object key) {
        return key instanceof Integer ? (V)this.remove((Integer)key) : null;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.array, null);
            this.size = 0;
        }
    }

    @Override
    public Set<Integer> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public int getMaxKey() {
        if (this.size > 0) {
            int i = this.array.length - 1;
            while (i >= 0) {
                if (this.array[i] != null) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public V[] toArray(Class<? super V> type) {
        int length = this.getMaxKey() + 1;
        Object[] array = (Object[])Array.newInstance(type, length);
        System.arraycopy(this.array, 0, array, 0, length);
        return array;
    }
}

