/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class IntArrayList
implements IntList {
    private static final int[] EMPTY_ARRAY = new int[0];
    private int[] array;
    private int size;

    public IntArrayList() {
        this.array = EMPTY_ARRAY;
    }

    public IntArrayList(int initialCapacity) {
        this.array = new int[initialCapacity];
    }

    public IntArrayList(int[] initialElements) {
        int size = initialElements.length;
        if (size != 0) {
            this.array = Arrays.copyOf(initialElements, size);
            this.size = size;
        } else {
            this.array = EMPTY_ARRAY;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int indexOf(int e) {
        int[] array = this.array;
        int size = this.size;
        int i = 0;
        while (i < size) {
            if (array[i] == e) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int e) {
        int[] array = this.array;
        int i = this.size - 1;
        while (i >= 0) {
            if (array[i] == e) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public boolean contains(int e) {
        return this.indexOf(e) >= 0;
    }

    @Override
    public int getAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.array[index];
    }

    @Override
    public int getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.array[0];
    }

    @Override
    public int getLast() {
        int size = this.size;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.array[size - 1];
    }

    protected final void ensureCapacity(int min) {
        if (min > this.array.length) {
            int newCapacity;
            if (this.array == EMPTY_ARRAY) {
                min = 8;
            }
            if ((newCapacity = Math.max(this.array.length + (this.array.length >> 1), min)) < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            int[] newArray = new int[newCapacity];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    @Override
    public boolean add(int e) {
        this.ensureCapacity(this.size + 1);
        this.array[this.size++] = e;
        return true;
    }

    @Override
    public void addAt(int index, int e) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        this.ensureCapacity(this.size + 1);
        if (index < this.size) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.array[index] = e;
        ++this.size;
    }

    @Override
    public int setAt(int index, int e) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        int oldElement = this.array[index];
        this.array[index] = e;
        return oldElement;
    }

    private void doRemoveElementBefore(int index) {
        if (index != this.size) {
            System.arraycopy(this.array, index, this.array, index - 1, this.size - index);
        }
    }

    @Override
    public boolean remove(int e) {
        int index = this.indexOf(e);
        if (index >= 0) {
            this.doRemoveElementBefore(index + 1);
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public int removeAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        int oldElement = this.array[index];
        this.doRemoveElementBefore(index + 1);
        --this.size;
        return oldElement;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public IntStream stream() {
        return StreamSupport.intStream(Spliterators.spliterator(this.array, 16), false);
    }

    @Override
    public int[] toArray() {
        return Arrays.copyOf(this.array, this.size);
    }

    @Override
    public void toArray(int[] array) {
        System.arraycopy(this.array, 0, array, 0, this.size);
    }

    @Override
    public String getString() {
        return new String(this.array, 0, this.size);
    }

    public String toString() {
        return ArrayUtils.toString(this.array, 0, this.size);
    }
}

