/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.eval;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.statet.ecommons.debug.core.eval.IEvaluationListener;
import org.eclipse.statet.ecommons.debug.core.eval.IEvaluationResult;
import org.eclipse.statet.internal.r.debug.core.Messages;
import org.eclipse.statet.internal.r.debug.core.RDebugCorePlugin;
import org.eclipse.statet.internal.r.debug.core.eval.EvaluationResult;
import org.eclipse.statet.internal.r.debug.core.eval.REvalExpressionTask;
import org.eclipse.statet.internal.r.debug.core.model.BasicRElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RMainThread;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.tool.TmpUtils;
import org.eclipse.statet.r.nico.AbstractRDbgController;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.RReferenceImpl;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.statet.rj.ts.core.console.AbstractRConsoleOptRunnable;

@NonNullByDefault
public class REvalExpressionRunnable
extends AbstractRConsoleOptRunnable
implements SystemRunnable {
    private final REvalExpressionTask task;
    private final int stamp;
    private final IEvaluationListener listener;
    private int state;

    public REvalExpressionRunnable(REvalExpressionTask task, int stamp, IEvaluationListener listener) {
        super("r/dbg/watch", Messages.Expression_Evaluate_task);
        this.task = task;
        this.stamp = stamp;
        this.listener = listener;
    }

    public boolean canRunIn(Tool tool) {
        return tool == this.task.getThread().getTool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changed(int event, Tool tool) {
        switch (event) {
            case 288: 
            case 289: {
                return false;
            }
            case 290: 
            case 336: 
            case 340: 
            case 344: {
                REvalExpressionRunnable rEvalExpressionRunnable = this;
                synchronized (rEvalExpressionRunnable) {
                    if (this.state == 0) {
                        this.state = event;
                        this.listener.evaluationFinished((IEvaluationResult)new EvaluationResult(this.task.getRExpression(), this.task.getThread()));
                    }
                    break;
                }
            }
        }
        return true;
    }

    protected void run(RToolService service, ProgressMonitor m) throws StatusException {
        try {
            AbstractRDbgController r = (AbstractRDbgController)service;
            if (this.stamp != r.getChangeStamp()) {
                return;
            }
            RMainThread thread = this.task.getThread();
            @Nullable EvaluationResult result = thread.getExpressionManager().getEvalResult(this.task.getKey());
            if (result != null) {
                this.state = 336;
                this.listener.evaluationFinished((IEvaluationResult)result);
                return;
            }
            TmpUtils.Item tmpItem = TmpUtils.newItem((String)"dbg_watch", (RService)r, (ProgressMonitor)m);
            try {
                this.evalExpression(tmpItem, r, m);
            }
            finally {
                if (this.state != 336) {
                    tmpItem.disposeChecked(m);
                }
            }
        }
        catch (CoreException | UnexpectedRDataException e) {
            this.state = 340;
            ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("An error occurred when evaluating the watch expression.");
            sb.addProp("expression", this.task.getRExpression());
            sb.addProp("frame", (Object)this.task.getStackFrame());
            RDebugCorePlugin.logError(sb.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalExpression(TmpUtils.Item tmpItem, AbstractRDbgController r, ProgressMonitor m) throws UnexpectedRDataException, StatusException, DebugException {
        CombinedRElement element;
        RMainThread thread = this.task.getThread();
        String valueName = tmpItem.createSub("value");
        RElementName valueElementName = RElementName.create((int)17, (String)valueName);
        RElementName fqElementName = TmpUtils.createFQElementName((RElementName)valueElementName);
        try {
            element = r.evalCombinedStruct(this.task.getRExpression(), (RObject)new RReferenceImpl(this.task.getStackFrame().getHandle().longValue(), 8, "environment"), 0, 0, fqElementName, m);
        }
        catch (StatusException e) {
            REvalExpressionRunnable rEvalExpressionRunnable = this;
            synchronized (rEvalExpressionRunnable) {
                this.state = 340;
                Status status = e.getStatus();
                if (status.getSeverity() == 8) {
                    this.evalCompleted(new EvaluationResult(this.task.getRExpression(), thread, 8, Messages.Expression_Evaluate_Cancelled_message));
                } else {
                    this.evalCompleted(new EvaluationResult(this.task.getRExpression(), thread, 4, status.getMessage()));
                }
                return;
            }
        }
        RReference ref = RDataUtils.checkRReference((RObject)element);
        tmpItem.set(valueName, (RObject)ref, m);
        if (ref.getReferencedRObjectType() == 8) {
            thread.resolveReference((CombinedRElement)ref, this.stamp, m);
        } else {
            element = r.getWorkspace().resolve(ref, 2, 0, m);
            if (element == null && (element = r.findCombinedStruct(valueElementName, TmpUtils.ENV_FQ_ELEMENT_NAME, false, 0, -1, m)) == null) {
                throw new UnexpectedRDataException("null");
            }
        }
        BasicRElementVariable variable = new BasicRElementVariable(element, thread, this.stamp, null);
        variable.getValue(m);
        this.state = 336;
        this.evalCompleted(new EvaluationResult(this.task.getRExpression(), thread, variable, tmpItem));
    }

    private void evalCompleted(EvaluationResult evalResult) {
        this.task.getThread().getExpressionManager().setEvalResult(this.task.getKey(), evalResult);
        this.listener.evaluationFinished((IEvaluationResult)evalResult);
    }
}

