/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.Qualifier;

public final class FetchDescriptor {
    private int row_length;
    private FormatableBitSet validColumns;
    private Qualifier[][] qualifier_list;
    private int[] materialized_cols;
    private int maxFetchColumnId;
    private static final int ZERO_FILL_LENGTH = 100;
    private static final int[] zero_fill_array = new int[100];
    private int[] validColumnsArray;

    FetchDescriptor() {
    }

    public FetchDescriptor(int input_row_length) {
        this.row_length = input_row_length;
    }

    public FetchDescriptor(int input_row_length, int single_valid_column_number) {
        this.row_length = input_row_length;
        this.maxFetchColumnId = single_valid_column_number;
        this.validColumnsArray = new int[this.maxFetchColumnId + 1];
        this.validColumnsArray[single_valid_column_number] = 1;
    }

    public FetchDescriptor(int input_row_length, FormatableBitSet input_validColumns, Qualifier[][] input_qualifier_list) {
        this.row_length = input_row_length;
        this.qualifier_list = input_qualifier_list;
        if (this.qualifier_list != null) {
            this.materialized_cols = new int[this.row_length];
        }
        this.setValidColumns(input_validColumns);
    }

    public final FormatableBitSet getValidColumns() {
        return this.validColumns;
    }

    public final int[] getValidColumnsArray() {
        return this.validColumnsArray;
    }

    public final void setValidColumns(FormatableBitSet input_validColumns) {
        this.validColumns = input_validColumns;
        this.setMaxFetchColumnId();
        if (this.validColumns != null) {
            this.validColumnsArray = new int[this.maxFetchColumnId + 1];
            for (int i = this.maxFetchColumnId; i >= 0; --i) {
                this.validColumnsArray[i] = this.validColumns.isSet(i) ? 1 : 0;
            }
        }
    }

    public final Qualifier[][] getQualifierList() {
        return this.qualifier_list;
    }

    public final int[] getMaterializedColumns() {
        return this.materialized_cols;
    }

    public final int getMaxFetchColumnId() {
        return this.maxFetchColumnId;
    }

    private final void setMaxFetchColumnId() {
        this.maxFetchColumnId = this.row_length - 1;
        if (this.validColumns != null) {
            int vCol_length = this.validColumns.getLength();
            if (vCol_length < this.maxFetchColumnId + 1) {
                this.maxFetchColumnId = vCol_length - 1;
            }
            while (this.maxFetchColumnId >= 0 && !this.validColumns.isSet(this.maxFetchColumnId)) {
                --this.maxFetchColumnId;
            }
        }
    }

    public final void reset() {
        int[] cols = this.materialized_cols;
        if (cols != null) {
            if (cols.length <= 100) {
                System.arraycopy(zero_fill_array, 0, cols, 0, cols.length);
            } else {
                int offset = 0;
                int howMany = cols.length;
                while (howMany > 0) {
                    int count = howMany > zero_fill_array.length ? zero_fill_array.length : howMany;
                    System.arraycopy(zero_fill_array, 0, cols, offset, count);
                    howMany -= count;
                    offset += count;
                }
            }
        }
    }
}

