/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.util.Iterator;
import java.util.List;
import org.eclipse.statet.internal.r.core.rmodel.RSrcStrElementByElementAccess;
import org.eclipse.statet.internal.r.core.rmodel.RoxygenAnalyzeContext;
import org.eclipse.statet.internal.r.core.rmodel.RoxygenTagType;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.rlang.RDocuLink;
import org.eclipse.statet.r.core.model.rlang.RLangSrcStrElement;
import org.eclipse.statet.r.core.source.ast.DocuComment;
import org.eclipse.statet.r.core.source.ast.DocuTag;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.SourceComponent;

public class RoxygenAnalyzer
implements LtkModelElementFilter<RLangSrcStrElement> {
    private RoxygenAnalyzeContext context;
    private List<RAstNode> comments;
    private Iterator<RAstNode> commentsIterator;
    private DocuComment nextComment;
    private int nextCommentRefOffset;

    public void updateModel(RoxygenAnalyzeContext context) {
        this.context = context;
        RSourceUnitModelInfo model = context.getModelInfo();
        this.comments = ((SourceComponent)model.getAst().getRoot()).getComments();
        if (this.comments == null || this.comments.isEmpty()) {
            return;
        }
        this.commentsIterator = this.comments.iterator();
        if (!this.nextDocuComment()) {
            return;
        }
        RLangSrcStrElement sourceElement = model.getSourceElement();
        if (sourceElement instanceof RLangSrcStrElement) {
            this.include(sourceElement);
        }
        if (this.nextComment != null) {
            this.checkElement(null);
        }
    }

    private boolean nextDocuComment() {
        while (this.commentsIterator.hasNext()) {
            RAstNode next = this.commentsIterator.next();
            if (next.getNodeType() != NodeType.DOCU_AGGREGATION) continue;
            this.nextComment = (DocuComment)next;
            this.nextCommentRefOffset = this.nextComment.getSubsequentNodeOffset();
            if (this.nextCommentRefOffset != Integer.MIN_VALUE) {
                return true;
            }
            this.checkElement(null);
        }
        this.nextComment = null;
        this.nextCommentRefOffset = Integer.MAX_VALUE;
        return false;
    }

    public boolean include(@NonNull RLangSrcStrElement element) {
        if (this.nextComment == null) {
            return true;
        }
        int offset = element.getSourceRange().getStartOffset();
        while (this.nextCommentRefOffset < offset) {
            this.checkElement(null);
            this.nextDocuComment();
        }
        if (this.nextCommentRefOffset == offset && element instanceof RSrcStrElementByElementAccess.DocuCommentableElement) {
            RDocuLink link = new RDocuLink(element, this.nextComment);
            this.nextComment.addAttachment(link);
            ((RSrcStrElementByElementAccess.DocuCommentableElement)element).setDocu(this.nextComment);
            this.checkElement(element);
            this.nextDocuComment();
        }
        if (this.nextCommentRefOffset < offset + element.getSourceRange().getLength()) {
            return element.hasSourceChildren(this);
        }
        return false;
    }

    private void checkElement(@Nullable RLangSrcStrElement element) {
        List<DocuTag> tags = this.nextComment.getTags();
        for (DocuTag tag : tags) {
            RoxygenTagType tagType = RoxygenTagType.TYPES.get(tag.getText());
            if (tagType == null) continue;
            tagType.analyze(this.context, tag, element);
        }
    }
}

