/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.variables.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.statet.ecommons.variables.core.ILocationVariable;
import org.eclipse.statet.ecommons.variables.core.StringVariable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class DynamicVariable
extends StringVariable
implements IDynamicVariable {
    private final boolean isArgumentSupported;

    public DynamicVariable(String name, @Nullable String description, boolean supportsArgument) {
        super(name, description);
        this.isArgumentSupported = supportsArgument;
    }

    public DynamicVariable(IStringVariable variable) {
        super(variable.getName(), variable.getDescription());
        this.isArgumentSupported = variable instanceof IDynamicVariable && ((IDynamicVariable)variable).supportsArgument();
    }

    public boolean supportsArgument() {
        return this.isArgumentSupported;
    }

    public @Nullable String getValue(@Nullable String argument) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", "At the moment not resolvable."));
    }

    @Deprecated
    public static abstract class LocationVariable
    extends DynamicVariable
    implements ILocationVariable {
        public LocationVariable(IStringVariable variable) {
            super(variable);
        }
    }

    public static class ResolverVariable
    extends DynamicVariable {
        private final IDynamicVariableResolver resolver;

        public ResolverVariable(String name, @Nullable String description, boolean supportsArgument, IDynamicVariableResolver resolver) {
            super(name, description, supportsArgument);
            this.resolver = (IDynamicVariableResolver)ObjectUtils.nonNullAssert((Object)resolver);
        }

        public ResolverVariable(IStringVariable variable, IDynamicVariableResolver resolver) {
            super(variable);
            this.resolver = (IDynamicVariableResolver)ObjectUtils.nonNullAssert((Object)resolver);
        }

        @Override
        public @Nullable String getValue(@Nullable String argument) throws CoreException {
            return this.resolver.resolveValue((IDynamicVariable)this, argument);
        }
    }
}

