/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors.rpkg;

import java.time.Clock;
import java.time.LocalDate;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.statet.dsl.dcf.core.source.ast.Field;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.internal.r.ui.editors.AbstractRCompletionElementComputer;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.ltk.core.util.EntityRole;
import org.eclipse.statet.ltk.core.util.UserInfo;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SimpleCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.model.RCoreFunctions;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RPkgDescrFieldDefinition;
import org.eclipse.statet.r.core.model.RPkgDescriptions;
import org.eclipse.statet.r.core.model.rlang.BasicRFrame;
import org.eclipse.statet.r.core.model.rlang.BasicRFrameSearchPath;
import org.eclipse.statet.r.core.model.rlang.BasicRLangMethod;
import org.eclipse.statet.r.core.model.rlang.RFrame;
import org.eclipse.statet.r.core.model.rlang.RFrameSearchPath;
import org.eclipse.statet.r.core.source.RSourceConfig;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.statet.r.ui.sourceediting.RPkgDescrAssistInvocationContext;
import org.eclipse.swt.graphics.Image;

@NonNullByDefault
public class RPkgDescrFieldValueCompletionComputer
extends AbstractRCompletionElementComputer
implements ContentAssistComputer {
    private static final int AUTHOR_NAME_SUBJECT = 1;
    private static final int AUTHOR_EMAIL_SUBJECT = 2;
    private static final ImSet<String> YES_NO_VALUES = ImCollections.newSet((Object[])new String[]{"yes", "no"});
    protected RPkgDescrAssistInvocationContext descrContext;
    protected Field fieldNode;
    protected RPkgDescrFieldDefinition fieldDef;

    public RPkgDescrFieldValueCompletionComputer() {
        super(0);
    }

    protected boolean initField() {
        String fieldName;
        this.fieldNode = this.getDescrContext().getInvocationDescrFieldNode();
        return this.fieldNode != null && (fieldName = this.fieldNode.getKey().getText()) != null && (this.fieldDef = RPkgDescriptions.getFieldDefinition((String)fieldName)) != null;
    }

    protected void initR(IProgressMonitor monitor) {
        if (!this.isRContext()) {
            this.initR(new RAssistInvocationContext(this.getDescrContext(), true, monitor), monitor);
        }
    }

    @Override
    protected void clear() {
        super.clear();
        this.descrContext = null;
        this.fieldNode = null;
        this.fieldDef = null;
    }

    protected RPkgDescrAssistInvocationContext getDescrContext() {
        return this.descrContext;
    }

    protected boolean isRContext() {
        return this.getRContext() != null;
    }

    @Override
    public void computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        try {
            this.proposals = proposals;
            if (context instanceof RPkgDescrAssistInvocationContext && context.getInvocationContentType() != "RPkgDescr.FieldName") {
                this.descrContext = (RPkgDescrAssistInvocationContext)context;
                this.computeCompletionProposals(mode, monitor);
            } else if (context instanceof RAssistInvocationContext) {
                this.descrContext = new RPkgDescrAssistInvocationContext(context, true, monitor);
                this.initR((RAssistInvocationContext)context, monitor);
                this.computeCompletionProposals(mode, monitor);
            }
        }
        finally {
            this.clear();
        }
    }

    @Override
    public void computeInformationProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        try {
            if (context instanceof RAssistInvocationContext) {
                this.descrContext = new RPkgDescrAssistInvocationContext(context, false, monitor);
                this.initR((RAssistInvocationContext)context, monitor);
                this.proposals = proposals;
                this.computeContextProposals(monitor);
            }
        }
        finally {
            this.clear();
        }
    }

    @Override
    protected void computeCompletionProposals(int mode, IProgressMonitor monitor) {
        if (!this.initField()) {
            return;
        }
        RPkgDescrFieldDefinition fieldDef = this.fieldDef;
        if (fieldDef == RPkgDescriptions.Encoding_FIELD) {
            this.addEncodingCompletions(monitor);
            return;
        }
        if (fieldDef == RPkgDescriptions.Type_FIELD) {
            this.addPkgTypeCompletions(monitor);
            return;
        }
        if (fieldDef == RPkgDescriptions.License_FIELD) {
            this.addLicenseCompletions(monitor);
            return;
        }
        if (fieldDef == RPkgDescriptions.Author_FIELD) {
            this.addPersonCompletions(true, true, monitor);
            return;
        }
        if (fieldDef == RPkgDescriptions.Maintainer_FIELD) {
            this.addPersonCompletions(false, false, monitor);
            return;
        }
        if (fieldDef == RPkgDescriptions.Authors_R_FIELD) {
            if (this.isRContext()) {
                this.addPersonRCompletions(monitor);
            }
            return;
        }
        if (fieldDef == RPkgDescriptions.NeedsCompilation_FIELD) {
            this.addFixedCompletions((ImCollection<String>)YES_NO_VALUES, monitor);
            return;
        }
        switch (fieldDef.getDataType()) {
            case 1: {
                this.addLogicalCompletions(monitor);
                return;
            }
            case 2: {
                this.addDateCompletions(monitor);
                return;
            }
            case 3: {
                if (this.getIdentifierPreceding() == 39) {
                    this.addPackageCompletions(monitor);
                }
                return;
            }
            case 6: 
            case 7: {
                this.addPackageCompletions(monitor);
                return;
            }
        }
    }

    @Override
    protected void computeContextProposals(IProgressMonitor monitor) {
        RAssistInvocationContext.FCallInfo fCallInfo;
        if (!this.initField()) {
            return;
        }
        RPkgDescrFieldDefinition fieldDef = this.fieldDef;
        if (fieldDef == RPkgDescriptions.Authors_R_FIELD && this.isRContext() && (fCallInfo = this.getRContext().getFCallInfo()) != null) {
            this.addFCallArgContexts(fCallInfo, (RFrameSearchPath)new BasicRFrameSearchPath(this.createAuthorREnvs()));
        }
    }

    protected void addEncodingCompletions(IProgressMonitor monitor) {
        String prefix = this.getDescrContext().getIdentifierPrefix();
        if (this.isValueStart(this.fieldNode, this.getDescrContext().getIdentifierOffset())) {
            ImList values = ImCollections.newList((Object)"UTF-8");
            SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)this.getDescrContext(), this.getDescrContext().getIdentifierOffset(), new SearchPattern(4, prefix));
            for (String value : values) {
                if (!parameters.matchesNamePattern(value)) continue;
                this.proposals.add((AssistProposal)new SimpleValueCompletionProposal((SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext>)parameters, value));
            }
        }
    }

    protected void addPkgTypeCompletions(IProgressMonitor monitor) {
        String prefix = this.getDescrContext().getIdentifierPrefix();
        if (this.isValueStart(this.fieldNode, this.getDescrContext().getIdentifierOffset())) {
            SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)this.getDescrContext(), this.getDescrContext().getIdentifierOffset(), new SearchPattern(4, prefix));
            for (String value : RPkgDescriptions.PKG_TYPES) {
                if (!parameters.matchesNamePattern(value)) continue;
                this.proposals.add((AssistProposal)new SimpleValueCompletionProposal((SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext>)parameters, value));
            }
        }
    }

    protected void addLicenseCompletions(IProgressMonitor monitor) {
        String prefix = this.getDescrContext().getIdentifierPrefix();
        SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)this.getDescrContext(), this.getDescrContext().getIdentifierOffset(), new SearchPattern(this.getSearchMatchRules(), prefix));
        ArrayList<String> values = new ArrayList<String>();
        values.add("file LICENSE");
        if (this.isValueStart(this.fieldNode, this.getDescrContext().getIdentifierOffset())) {
            values.add("Unlimited");
        }
        for (RPkgDescriptions.LicenseSpec spec : RPkgDescriptions.STANDARD_LICENSE_SPECS) {
            if (!parameters.matchesNamePattern(spec.abbr())) continue;
            this.proposals.add((AssistProposal)new SimpleValueCompletionProposal((SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext>)parameters, spec.abbr(), spec.name()));
        }
        for (String value : values) {
            if (!parameters.matchesNamePattern(value)) continue;
            this.proposals.add((AssistProposal)new SimpleValueCompletionProposal((SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext>)parameters, value));
        }
    }

    protected void addLogicalCompletions(IProgressMonitor monitor) {
        this.addFixedCompletions((ImCollection<String>)RPkgDescriptions.LOGICAL_VALUES, monitor);
    }

    protected void addFixedCompletions(ImCollection<String> values, IProgressMonitor monitor) {
        String prefix = this.getDescrContext().getIdentifierPrefix();
        if (this.isValueStart(this.fieldNode, this.getDescrContext().getIdentifierOffset())) {
            SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)this.getDescrContext(), this.getDescrContext().getIdentifierOffset(), new SearchPattern(4, prefix));
            for (String value : values) {
                if (!parameters.matchesNamePattern(value)) continue;
                this.proposals.add((AssistProposal)new SimpleValueCompletionProposal((SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext>)parameters, value));
            }
        }
    }

    protected void addDateCompletions(IProgressMonitor monitor) {
        String prefix = this.getDescrContext().getIdentifierPrefix();
        SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)this.getDescrContext(), this.getDescrContext().getIdentifierOffset(), new SearchPattern(this.getSearchMatchRules(), prefix));
        if (this.isValueStart(this.fieldNode, this.getDescrContext().getIdentifierOffset())) {
            LocalDate date = LocalDate.now(Clock.systemUTC());
            ImList values = ImCollections.newList((Object)date.toString());
            for (String value : values) {
                if (!parameters.matchesNamePattern(value)) continue;
                this.proposals.add((AssistProposal)new SimpleValueCompletionProposal((SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext>)parameters, value));
            }
        }
    }

    protected void addPersonCompletions(boolean multiple, boolean roles, IProgressMonitor monitor) {
        block8: {
            String authorName;
            UserInfo authorInfo;
            SourceProposal.ProposalParameters parameters;
            block7: {
                String prefix = this.getDescrContext().getIdentifierPrefix();
                int preceding = this.getIdentifierPreceding();
                if (roles && this.isInSquareBrackets(this.getDescrContext().getIdentifierOffset())) {
                    SourceProposal.ProposalParameters parameters2 = new SourceProposal.ProposalParameters((AssistInvocationContext)this.getDescrContext(), this.getDescrContext().getIdentifierOffset(), new SearchPattern(4, prefix), 30);
                    for (EntityRole role : EntityRole.COMMON_ROLES) {
                        if ((role.getFlags() & 0x1000) == 0 || !parameters2.matchesNamePattern(role.getCode())) continue;
                        this.proposals.add((AssistProposal)new SimpleValueCompletionProposal((SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext>)parameters2, role.getCode(), role.getName()));
                    }
                    return;
                }
                parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)this.getDescrContext(), this.getDescrContext().getIdentifierOffset(), new SearchPattern(this.getSearchMatchRules(), prefix));
                authorInfo = UserInfo.getAuthorInfo();
                authorName = authorInfo.getName();
                if (preceding != 60) break block7;
                ArrayList<String> values = new ArrayList<String>();
                if (!authorInfo.getEmail().isEmpty()) {
                    values.add(authorInfo.getEmail());
                }
                for (String string : values) {
                    if (!parameters.matchesNamePattern(string)) continue;
                    this.proposals.add((AssistProposal)new SimpleValueCompletionProposal((SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext>)parameters, string));
                }
                break block8;
            }
            if (!multiple && !this.isValueStart(this.fieldNode, this.getDescrContext().getIdentifierOffset())) break block8;
            ArrayList<Object> persons = new ArrayList<Object>();
            if (!authorName.isEmpty()) {
                persons.add(authorName);
                if (!authorInfo.getEmail().isEmpty()) {
                    persons.add(authorName + " <" + authorInfo.getEmail() + ">");
                }
            }
            for (String string : persons) {
                if (!parameters.matchesNamePattern(string)) continue;
                this.proposals.add((AssistProposal)new PersonValueCompletionProposal((SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext>)parameters, string));
            }
        }
    }

    @Override
    protected boolean checkArgsDef(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable RFunctionSpec.Parameter parameter, @Nullable RElementName fName, boolean guess, int relevance) {
        block15: {
            String name;
            if (super.checkArgsDef(parameter, fName, guess, relevance)) {
                return true;
            }
            if (parameter == null || (name = parameter.getName()) == null) break block15;
            int prio = 40 + relevance;
            if (this.fieldDef != RPkgDescriptions.Authors_R_FIELD) break block15;
            switch (name) {
                case "family": 
                case "middle": 
                case "given": {
                    this.addSubject(1, prio);
                    return true;
                }
                case "email": {
                    this.addSubject(2, prio);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected void addPersonRCompletions(IProgressMonitor monitor) {
        RElementName prefixName = this.getRContext().getIdentifierElementName();
        String prefix = this.getDescrContext().getIdentifierPrefix();
        UserInfo authorInfo = UserInfo.getAuthorInfo();
        String authorName = authorInfo.getName();
        BasicRFrameSearchPath searchPath = new BasicRFrameSearchPath(this.createAuthorREnvs());
        RAssistInvocationContext.FCallInfo personFCallInfo = null;
        RAssistInvocationContext.FCallInfo fCallInfo = this.getRContext().getFCallInfo();
        if (fCallInfo != null) {
            personFCallInfo = this.isFun(RCoreFunctions.UTILS_Person_ELEMENT_NAME, (RElementName)fCallInfo.getAccess()) ? fCallInfo : this.findFCall(fCallInfo.getNode().getRParent(), "person");
        }
        if (prefixName != null && prefixName.getNextSegment() == null) {
            if (this.in == 1) {
                try {
                    this.addMainElementCompletions((RFrameSearchPath)searchPath, prefixName);
                }
                catch (Exception e) {
                    this.log(e);
                }
            }
            if (fCallInfo != null) {
                try {
                    this.addFCallArgCompletions(fCallInfo, prefixName, (RFrameSearchPath)searchPath);
                }
                catch (Exception e) {
                    this.log(e);
                }
                try {
                    AbstractRCompletionElementComputer.ContextSubject subject = this.getSubject(0x100000);
                    if (subject != null && subject.prio > 0) {
                        this.addRoleCodeCompletions(subject.prio);
                    }
                    ArrayList<String> values = new ArrayList<String>();
                    subject = this.getSubject(1);
                    if (subject != null && subject.prio > 0 && !authorName.isEmpty()) {
                        int spaceIndex = authorName.lastIndexOf(32);
                        if (spaceIndex != -1) {
                            values.add(authorName.substring(0, spaceIndex));
                            values.add(authorName.substring(spaceIndex + 1, authorName.length()));
                        } else {
                            values.add(authorName);
                        }
                    }
                    if ((subject = this.getSubject(2)) != null && subject.prio > 0 && !authorInfo.getEmail().isEmpty()) {
                        values.add(authorInfo.getEmail());
                    }
                    if (!values.isEmpty()) {
                        SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)this.getDescrContext(), this.getDescrContext().getIdentifierOffset(), new SearchPattern(this.getSearchMatchRules(), prefix), 40);
                        for (String value : values) {
                            if (!parameters.matchesNamePattern(value)) continue;
                            this.proposals.add((AssistProposal)new SimpleValueCompletionProposal((SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext>)parameters, value));
                        }
                    }
                }
                catch (Exception e) {
                    this.log(e);
                }
            }
        }
        if (this.in == 1 && personFCallInfo == null && !authorName.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            RCodeStyleSettings rCodeStyle = this.getDescrContext().getRCoreAccess().getRCodeStyle();
            int emailIndex = -1;
            sb.append("person(");
            int spaceIndex = authorName.lastIndexOf(32);
            if (spaceIndex != -1) {
                sb.append('\"');
                sb.append(authorName, 0, spaceIndex);
                sb.append("\", \"");
                sb.append(authorName, spaceIndex + 1, authorName.length());
                sb.append('\"');
            } else {
                sb.append('\"');
                sb.append(authorName);
                sb.append('\"');
            }
            sb.append(", role");
            sb.append(rCodeStyle.getArgAssignString());
            int roleIndex = sb.length();
            sb.append(')');
            SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)this.getDescrContext(), this.getDescrContext().getIdentifierOffset(), new SearchPattern(this.getSearchMatchRules(), prefix));
            if (parameters.matchesNamePattern(authorName)) {
                this.proposals.add((AssistProposal)new PersonRValueCompletionProposal((SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext>)parameters, authorName, sb.toString(), roleIndex, -1));
                if (!authorInfo.getEmail().isEmpty()) {
                    sb.delete(sb.length() - 1, sb.length());
                    sb.append(", email");
                    sb.append(rCodeStyle.getArgAssignString());
                    sb.append('\"');
                    sb.append(authorInfo.getEmail());
                    sb.append('\"');
                    sb.append(')');
                    this.proposals.add((AssistProposal)new PersonRValueCompletionProposal((SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext>)parameters, authorName + " <" + authorInfo.getEmail() + ">", sb.toString(), roleIndex, -1));
                }
            }
        }
    }

    protected ImList<RFrame<?>> createAuthorREnvs() {
        RCoreFunctions rCoreFunctions = RCoreFunctions.getDefinitions((RSourceConfig)this.getRContext().getRCoreAccess().getRSourceConfig());
        BasicRFrame baseEnv = new BasicRFrame(2, RCoreFunctions.BASE_PACKAGE_NS_ELEMENT_NAME, ImCollections.newList((Object)new BasicRLangMethod(RCoreFunctions.BASE_C_ELEMENT_NAME, rCoreFunctions.BASE_C_fSpec)));
        BasicRFrame utilsEnv = new BasicRFrame(2, RCoreFunctions.UTILS_PACKAGE_NS_ELEMENT_NAME, ImCollections.newList((Object)new BasicRLangMethod(RCoreFunctions.UTILS_Person_ELEMENT_NAME, rCoreFunctions.UTILS_Person_fSpec)));
        return ImCollections.newList((Object[])new RFrame[]{utilsEnv, baseEnv});
    }

    protected void addPackageCompletions(IProgressMonitor monitor) {
        this.initR(monitor);
        String prefix = this.getDescrContext().getIdentifierPrefix();
        this.addPkgNameCompletions(prefix, 0);
    }

    private int getIdentifierPreceding() {
        try {
            IDocument document = this.getDescrContext().getDocument();
            if (this.getDescrContext().getIdentifierOffset() > 0) {
                return document.getChar(this.getDescrContext().getIdentifierOffset() - 1);
            }
            return -1;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValueStart(Field fieldNode, int offset) {
        try {
            IDocument document = this.getDescrContext().getDocument();
            int startOffset = fieldNode.getValueIndicatorOffset();
            startOffset = startOffset != Integer.MIN_VALUE ? ++startOffset : fieldNode.getKey().getEndOffset();
            block5: while (true) {
                if (startOffset >= offset) {
                    return true;
                }
                switch (document.getChar(startOffset)) {
                    case '\t': 
                    case ' ': {
                        ++startOffset;
                        continue block5;
                    }
                }
                break;
            }
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isInSquareBrackets(int offset) {
        try {
            IDocument document = this.getDescrContext().getDocument();
            block6: while (true) {
                if (--offset < 0) {
                    return false;
                }
                switch (document.getChar(offset)) {
                    case '\t': 
                    case ' ': 
                    case ',': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        continue block6;
                    }
                    case '[': {
                        return true;
                    }
                }
                break;
            }
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    private static class PersonRValueCompletionProposal
    extends PersonValueCompletionProposal {
        private final String replacementString;
        private final int roleIndex;
        private final int emailIndex;

        public PersonRValueCompletionProposal(SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext> parameters, String name, String replacementString, int roleOffset, int emailOffset) {
            super(parameters, name);
            this.replacementString = replacementString;
            this.roleIndex = roleOffset;
            this.emailIndex = emailOffset;
        }

        protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
            AssistInvocationContext context = this.getInvocationContext();
            IDocument document = context.getDocument();
            SourceProposal.ApplyData applyData = this.getApplyData();
            StringBuilder replacement = new StringBuilder(this.replacementString);
            int cursor = replacement.length();
            if (this.roleIndex >= 0) {
                cursor = this.roleIndex;
            } else if (this.emailIndex >= 0) {
                cursor = this.emailIndex;
            }
            document.replace(replacementOffset, replacementLength, replacement.toString());
            applyData.setSelection(replacementOffset + cursor);
            if (this.roleIndex >= 0 || this.emailIndex >= 0) {
                this.createLinkedMode(replacementOffset, replacement.length()).enter();
            }
        }

        private LinkedModeUI createLinkedMode(int offset, int mode) throws BadLocationException {
            LinkedPositionGroup group;
            AssistInvocationContext context = this.getInvocationContext();
            IDocument document = context.getDocument();
            LinkedModeModel model = new LinkedModeModel();
            if (this.roleIndex >= 0) {
                group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, offset + this.roleIndex, 0));
                model.addGroup(group);
            }
            if (this.emailIndex >= 0) {
                group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, offset + this.emailIndex, 0));
                model.addGroup(group);
            }
            model.forceInstall();
            LinkedModeUI ui = new LinkedModeUI(model, (ITextViewer)context.getSourceViewer());
            ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
            ui.setExitPosition((ITextViewer)context.getSourceViewer(), offset + (mode & 0xFFF), 0, Integer.MAX_VALUE);
            return ui;
        }
    }

    private static class PersonValueCompletionProposal
    extends SimpleValueCompletionProposal {
        public PersonValueCompletionProposal(SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext> parameters, String replacementString) {
            super(parameters, replacementString);
        }

        public Image getImage() {
            return SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/images/obj/user");
        }

        public @Nullable CharSequence getPrefixCompletionText(IDocument document, int offset) {
            return null;
        }
    }

    private static class SimpleValueCompletionProposal
    extends SimpleCompletionProposal<RPkgDescrAssistInvocationContext> {
        public SimpleValueCompletionProposal(SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext> parameters, String replacementString, String description) {
            super(parameters, replacementString, description);
        }

        public SimpleValueCompletionProposal(SourceProposal.ProposalParameters<? extends RPkgDescrAssistInvocationContext> parameters, String replacementString) {
            super(parameters, replacementString);
        }
    }
}

