/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.mpbv;

import java.util.List;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserBookmark;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.mpbv.EditBookmarkDialog;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookBrowserView;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ManageBookmarksDialog
extends TrayDialog {
    private TableViewer tableViewer;
    private ButtonGroup<BrowserBookmark> buttons;
    private final PageBookBrowserView view;
    private final List<BrowserBookmark> bookmarks;

    protected ManageBookmarksDialog(PageBookBrowserView view) {
        super(view.getViewSite().getShell());
        this.view = view;
        this.bookmarks = view.getBookmarks();
        this.create();
    }

    protected void configureShell(Shell shell) {
        shell.setText("Bookmarks");
        super.configureShell(shell);
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.buttons.updateState();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newDialogGrid(2));
        this.tableViewer = new TableViewer(composite);
        this.tableViewer.setUseHashlookup(true);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = LayoutUtils.hintWidth(this.tableViewer.getTable(), 60);
        gd.heightHint = LayoutUtils.hintHeight(this.tableViewer.getTable(), 20);
        this.tableViewer.getControl().setLayoutData((Object)gd);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.buttons = new ButtonGroup<BrowserBookmark>(composite){

            @Override
            protected BrowserBookmark edit1(BrowserBookmark item, boolean newItem, Object parent) {
                EditBookmarkDialog dialog = new EditBookmarkDialog(this.getShell(), item);
                if (dialog.open() == 0) {
                    return dialog.getBookmark();
                }
                return null;
            }

            @Override
            public void updateState() {
                super.updateState();
                ManageBookmarksDialog.this.getButton(11).setEnabled(((IStructuredSelection)ManageBookmarksDialog.this.tableViewer.getSelection()).size() == 1);
            }
        };
        this.buttons.setLayoutData(new GridData(4, 4, false, false));
        this.buttons.addAddButton(null);
        this.buttons.addEditButton(null);
        this.buttons.addDeleteButton(null);
        this.buttons.addSeparator();
        this.buttons.addUpButton(null);
        this.buttons.addDownButton(null);
        WritableList writableList = new WritableList(this.bookmarks, BrowserBookmark.class);
        this.tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.tableViewer.setInput((Object)writableList);
        this.buttons.connectTo((StructuredViewer)this.tableViewer, (IObservableCollection<BrowserBookmark>)writableList, null);
        ViewerUtils.scheduleStandardSelection(this.tableViewer);
        ManageBookmarksDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 11, IDialogConstants.OPEN_LABEL, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 11) {
            BrowserBookmark bookmark = (BrowserBookmark)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
            this.view.openBookmark(bookmark, (BrowserSession)this.view.getCurrentSession());
            this.close();
        }
        if (buttonId == 12) {
            this.close();
        }
    }
}

