/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core;

import org.eclipse.statet.docmlet.tex.core.TexCodeStyleSettings;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommandSet;
import org.eclipse.statet.ecommons.preferences.AbstractPreferencesModelObject;
import org.eclipse.statet.ecommons.preferences.PreferencesManageListener;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
final class BasicTexCoreAccess
implements TexCoreAccess {
    private static final ImIdentitySet<String> PREF_QUALIFIERS = ImCollections.newIdentitySet((Object)"org.eclipse.statet.docmlet.tex.core/tex.commands");
    private boolean isDisposed;
    private final PreferenceAccess prefs;
    private PreferenceSetService.ChangeListener commonPrefsListener;
    private TexCommandSet commandSet;
    private @Nullable TexCodeStyleSettings codeStyle;
    private PreferencesManageListener codeStyleListener;

    public BasicTexCoreAccess(PreferenceAccess prefs) {
        this.prefs = prefs;
        this.commonPrefsListener = new PreferenceSetService.ChangeListener(){

            public void onPreferenceChanged(PreferenceSetService.ChangeEvent event) {
                if (event.contains("org.eclipse.statet.docmlet.tex.core/tex.commands")) {
                    BasicTexCoreAccess.this.updateCommandSet();
                }
            }
        };
        this.prefs.addPreferenceSetListener(this.commonPrefsListener, PREF_QUALIFIERS);
        this.updateCommandSet();
    }

    @Override
    public PreferenceAccess getPrefs() {
        return this.prefs;
    }

    private synchronized void updateCommandSet() {
        this.commandSet = new TexCommandSet(this.prefs);
    }

    @Override
    public TexCommandSet getTexCommandSet() {
        return this.commandSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TexCodeStyleSettings getTexCodeStyle() {
        TexCodeStyleSettings codeStyle = this.codeStyle;
        if (codeStyle == null) {
            BasicTexCoreAccess basicTexCoreAccess = this;
            synchronized (basicTexCoreAccess) {
                codeStyle = this.codeStyle;
                if (codeStyle == null) {
                    codeStyle = new TexCodeStyleSettings(1);
                    if (!this.isDisposed) {
                        this.codeStyleListener = new PreferencesManageListener((AbstractPreferencesModelObject)codeStyle, this.prefs, TexCodeStyleSettings.ALL_GROUP_IDS);
                    }
                    codeStyle.load(this.prefs);
                    codeStyle.resetDirty();
                    this.codeStyle = codeStyle;
                }
            }
        }
        return codeStyle;
    }

    public synchronized void dispose() {
        this.isDisposed = true;
        if (this.codeStyleListener != null) {
            this.codeStyleListener.dispose();
            this.codeStyleListener = null;
        }
        if (this.commonPrefsListener != null) {
            this.prefs.removePreferenceSetListener(this.commonPrefsListener);
            this.commonPrefsListener = null;
        }
    }
}

