/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.eclipse.statet.internal.jcommons.collections.AbstractImIntList;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class ImIntEmptyList
extends AbstractImIntList {
    public static final ImIntEmptyList INSTANCE = new ImIntEmptyList();

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean contains(int e) {
        return false;
    }

    @Override
    public int getAt(int index) {
        throw new IndexOutOfBoundsException("index= " + index);
    }

    @Override
    public int getFirst() {
        throw new NoSuchElementException();
    }

    @Override
    public int getLast() {
        throw new NoSuchElementException();
    }

    @Override
    public int indexOf(int e) {
        return -1;
    }

    @Override
    public int lastIndexOf(int e) {
        return -1;
    }

    @Override
    public IntStream stream() {
        return StreamSupport.intStream(Spliterators.emptyIntSpliterator(), false);
    }

    @Override
    public int[] toArray() {
        return ArrayUtils.EMPTY_INT;
    }

    @Override
    public void toArray(int[] array) {
        ObjectUtils.nonNullAssert(array);
    }

    @Override
    public void copyTo(int srcIndex, int[] dest, int destIndex, int length) {
        assert (false);
    }

    @Override
    public void copyTo(int[] dest, int destIndex) {
    }

    @Override
    public String getString() {
        return "";
    }

    public int hashCode() {
        return 9;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntList) {
            IntList other = (IntList)obj;
            return other.isEmpty();
        }
        return false;
    }

    public String toString() {
        return "[]";
    }
}

