/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.sourcelookup;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.internal.r.debug.ui.RDebugUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.debug.core.sourcelookup.RRuntimeSourceFragment;
import org.eclipse.statet.r.debug.core.sourcelookup.RSourceLookupMatch;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RSourceLookupAdapterFactory
implements IAdapterFactory,
IWorkbenchAdapter,
IContributorResourceAdapter {
    private static final @NonNull Class<?>[] ADAPTERS = new Class[]{IWorkbenchAdapter.class, IContributorResourceAdapter.class};

    public @NonNull Class<?>[] getAdapterList() {
        return ADAPTERS;
    }

    public <T> @Nullable T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == IWorkbenchAdapter.class || adapterType == IContributorResourceAdapter.class) {
            return (T)this;
        }
        return null;
    }

    public @NonNull Object[] getChildren(Object o) {
        return null;
    }

    public @Nullable Object getParent(Object o) {
        return null;
    }

    public @Nullable ImageDescriptor getImageDescriptor(Object obj) {
        if (obj instanceof RSourceLookupMatch) {
            IWorkbenchAdapter adapter;
            Object element = ((RSourceLookupMatch)obj).getElement();
            if (element instanceof RRuntimeSourceFragment) {
                return RDebugUIPlugin.getInstance().getImageRegistry().getDescriptor("org.eclipse.statet.r.images/obj/r_source.runtime");
            }
            if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(element, IWorkbenchAdapter.class)) != null) {
                return adapter.getImageDescriptor(element);
            }
        }
        return null;
    }

    public String getLabel(Object obj) {
        if (obj instanceof RSourceLookupMatch) {
            IWorkbenchAdapter adapter;
            Object element = ((RSourceLookupMatch)obj).getElement();
            if (element instanceof RRuntimeSourceFragment) {
                RRuntimeSourceFragment fragment = (RRuntimeSourceFragment)element;
                return fragment.getName() + "  \u2012  " + fragment.getProcess().getLabel(0);
            }
            if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(element, IWorkbenchAdapter.class)) != null) {
                return adapter.getLabel(element);
            }
            return element.toString();
        }
        return obj.toString();
    }

    public @Nullable IResource getAdaptedResource(IAdaptable obj) {
        Object element;
        if (obj instanceof RSourceLookupMatch && (element = ((RSourceLookupMatch)obj).getElement()) instanceof IResource) {
            return (IResource)element;
        }
        return null;
    }
}

