/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

class LOBFile {
    private final StorageFile storageFile;
    private final StorageRandomAccessFile randomAccessFile;

    LOBFile(StorageFile storageFile) throws FileNotFoundException {
        this.storageFile = storageFile;
        this.randomAccessFile = storageFile.getRandomAccessFile("rw");
    }

    StorageFile getStorageFile() {
        return this.storageFile;
    }

    long length() throws IOException {
        return this.randomAccessFile.length();
    }

    void seek(long l) throws IOException {
        this.randomAccessFile.seek(l);
    }

    void write(int n) throws IOException, StandardException {
        this.randomAccessFile.write(n);
    }

    long getFilePointer() throws IOException {
        return this.randomAccessFile.getFilePointer();
    }

    void write(byte[] byArray, int n, int n2) throws IOException, StandardException {
        this.randomAccessFile.write(byArray, n, n2);
    }

    int readByte() throws IOException, StandardException {
        return this.randomAccessFile.readByte();
    }

    int read(byte[] byArray, int n, int n2) throws IOException, StandardException {
        return this.randomAccessFile.read(byArray, n, n2);
    }

    void close() throws IOException {
        this.randomAccessFile.close();
    }

    void setLength(long l) throws IOException, StandardException {
        this.randomAccessFile.setLength(l);
    }

    void write(byte[] byArray) throws IOException, StandardException {
        this.randomAccessFile.write(byArray);
    }
}

