/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r.ui.editors;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.docmlet.tex.core.model.TexModel;
import org.eclipse.statet.docmlet.tex.ui.editors.TexEditorBuild;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceAnnotationModel;
import org.eclipse.statet.ltk.ui.sourceediting.SourceDocumentProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceProblemAnnotation;
import org.eclipse.statet.r.ui.editors.REditorBuild;
import org.eclipse.statet.redocs.tex.r.core.model.LtxRweaveSourceUnit;
import org.eclipse.statet.redocs.tex.r.core.source.LtxRweaveDocumentSetupParticipant;

public class LtxRweaveDocumentProvider
extends SourceDocumentProvider<LtxRweaveSourceUnit>
implements Disposable {
    private SettingsChangeNotifier.ChangeListener editorPrefListener = new SettingsChangeNotifier.ChangeListener(){

        public void settingsChanged(Set<String> groupIds) {
            if (groupIds.contains("r/r.editor/build.options") || groupIds.contains("Tex/editor/build")) {
                LtxRweaveDocumentProvider.this.updateEditorPrefs();
            }
        }
    };
    private boolean handleTemporaryDocProblems;
    private boolean handleTemporaryRProblems;

    public LtxRweaveDocumentProvider() {
        super("LtxRweave", (PartitionerDocumentSetupParticipant)new LtxRweaveDocumentSetupParticipant());
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener(this.editorPrefListener);
        PreferenceAccess access = PreferenceUtils.getInstancePrefs();
        this.handleTemporaryDocProblems = (Boolean)access.getPreferenceValue((Preference)TexEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        this.handleTemporaryRProblems = (Boolean)access.getPreferenceValue((Preference)REditorBuild.PROBLEMCHECKING_ENABLED_PREF);
    }

    public void dispose() {
        if (this.editorPrefListener != null) {
            PreferencesUtil.getSettingsChangeNotifier().removeChangeListener(this.editorPrefListener);
            this.editorPrefListener = null;
        }
    }

    private void updateEditorPrefs() {
        PreferenceAccess access = PreferenceUtils.getInstancePrefs();
        boolean newHandleTemporaryTexProblems = (Boolean)access.getPreferenceValue((Preference)TexEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        boolean newHandleTemporaryRProblems = (Boolean)access.getPreferenceValue((Preference)REditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        if (this.handleTemporaryDocProblems != newHandleTemporaryTexProblems || this.handleTemporaryRProblems != newHandleTemporaryRProblems) {
            boolean enabled = this.handleTemporaryDocProblems != newHandleTemporaryTexProblems && newHandleTemporaryTexProblems || this.handleTemporaryRProblems != newHandleTemporaryRProblems && newHandleTemporaryRProblems;
            this.handleTemporaryDocProblems = newHandleTemporaryRProblems;
            this.handleTemporaryRProblems = newHandleTemporaryRProblems;
            if (enabled) {
                TexModel.getLtxModelManager().refresh(LTK.EDITOR_CONTEXT);
            } else {
                Object mode = !this.handleTemporaryDocProblems ? (!this.handleTemporaryRProblems ? null : "Ltx") : "R";
                List sus = LTK.getSourceUnitManager().getOpenSourceUnits("R", LTK.EDITOR_CONTEXT);
                for (ISourceUnit su : sus) {
                    IAnnotationModel model = this.getAnnotationModel(su);
                    if (!(model instanceof ThisAnnotationModel)) continue;
                    ((ThisAnnotationModel)model).clearProblems((String)mode);
                }
            }
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new ThisAnnotationModel((IResource)file);
    }

    private class ThisAnnotationModel
    extends SourceAnnotationModel {
        public ThisAnnotationModel(IResource resource) {
            super(resource);
        }

        protected boolean isHandlingTemporaryProblems() {
            return LtxRweaveDocumentProvider.this.handleTemporaryDocProblems;
        }

        protected boolean isHandlingTemporaryRProblems() {
            return LtxRweaveDocumentProvider.this.handleTemporaryRProblems;
        }

        protected ProblemRequestor doCreateProblemRequestor() {
            return new ThisProblemRequestor();
        }

        protected SourceProblemAnnotation createAnnotation(Problem problem) {
            if (problem.getCategoryId() == "R") {
                switch (problem.getSeverity()) {
                    case 2: {
                        return new SourceProblemAnnotation("org.eclipse.statet.r.ui.error", problem, SourceProblemAnnotation.ERROR_CONFIG);
                    }
                    case 1: {
                        return new SourceProblemAnnotation("org.eclipse.statet.r.ui.warning", problem, SourceProblemAnnotation.WARNING_CONFIG);
                    }
                }
                return new SourceProblemAnnotation("org.eclipse.statet.r.ui.info", problem, SourceProblemAnnotation.INFO_CONFIG);
            }
            if (problem.getCategoryId() == "Ltx") {
                switch (problem.getSeverity()) {
                    case 2: {
                        return new SourceProblemAnnotation("org.eclipse.statet.docmlet.tex.ui.error", problem, SourceProblemAnnotation.ERROR_CONFIG);
                    }
                    case 1: {
                        return new SourceProblemAnnotation("org.eclipse.statet.docmlet.tex.ui.warning", problem, SourceProblemAnnotation.WARNING_CONFIG);
                    }
                }
                return new SourceProblemAnnotation("org.eclipse.statet.docmlet.tex.ui.info", problem, SourceProblemAnnotation.INFO_CONFIG);
            }
            return null;
        }

        private class ThisProblemRequestor
        extends SourceAnnotationModel.SourceAnnotationProblemRequestor {
            private final boolean handleTemporaryRProblems;

            public ThisProblemRequestor() {
                super((SourceAnnotationModel)ThisAnnotationModel.this);
                this.handleTemporaryRProblems = ThisAnnotationModel.this.isHandlingTemporaryRProblems();
            }

            public void acceptProblems(Problem problem) {
                if (problem.getCategoryId() == "R") {
                    if (this.handleTemporaryRProblems) {
                        this.reportedProblems.add(problem);
                    }
                } else if (this.handleTemporaryProblems) {
                    this.reportedProblems.add(problem);
                }
            }

            public void acceptProblems(String modelTypeId, List<Problem> problems) {
                if (modelTypeId == "R") {
                    if (this.handleTemporaryRProblems) {
                        this.reportedProblems.addAll(problems);
                    }
                } else if (this.handleTemporaryProblems) {
                    this.reportedProblems.addAll(problems);
                }
            }
        }
    }
}

