/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.yaml.core.ast.YamlAst;
import org.eclipse.statet.yaml.core.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.ast.YamlAstVisitor;

@NonNullByDefault
public class Tuple
extends YamlAstNode {
    int keyIndicatorOffset = Integer.MIN_VALUE;
    YamlAstNode keyNode;
    int valueIndicatorOffset = Integer.MIN_VALUE;
    YamlAstNode valueNode;

    Tuple(YamlAstNode parent, int startOffset, int endOffset) {
        super(parent, startOffset, endOffset);
    }

    @Override
    public YamlAst.NodeType getNodeType() {
        return YamlAst.NodeType.MAP_ENTRY;
    }

    public boolean hasChildren() {
        return true;
    }

    public int getChildCount() {
        return 2;
    }

    public int getKeyIndicatorOffset() {
        return this.keyIndicatorOffset;
    }

    public YamlAstNode getKeyNode() {
        return this.keyNode;
    }

    public int getValueIndicatorOffset() {
        return this.valueIndicatorOffset;
    }

    public YamlAstNode getValueNode() {
        return this.valueNode;
    }

    @Override
    public YamlAstNode getChild(int index) {
        switch (index) {
            case 0: {
                return this.keyNode;
            }
            case 1: {
                return this.valueNode;
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    public int getChildIndex(AstNode element) {
        if (element == this.keyNode) {
            return 0;
        }
        if (element == this.valueNode) {
            return 1;
        }
        return -1;
    }

    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.keyNode);
        visitor.visit((AstNode)this.valueNode);
    }

    @Override
    public void acceptInYaml(YamlAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public void acceptInYamlChildren(YamlAstVisitor visitor) throws InvocationTargetException {
        this.keyNode.acceptInYaml(visitor);
        this.valueNode.acceptInYaml(visitor);
    }
}

