/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.statet.internal.r.core.RProjectNature;
import org.eclipse.statet.internal.r.core.builder.ExportedRClass;
import org.eclipse.statet.internal.r.core.builder.ExportedRElement;
import org.eclipse.statet.internal.r.core.builder.ExportedRMethod;
import org.eclipse.statet.internal.r.core.builder.RPkgData;
import org.eclipse.statet.internal.r.core.builder.RUnitElement;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.model.IRClass;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRFrameInSource;
import org.eclipse.statet.r.core.model.IRLangElement;
import org.eclipse.statet.r.core.model.IRMethod;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.IRSourceUnit;

public class RModelIndexOrder {
    protected final RProjectNature rProject;
    protected final String projectName;
    protected RPkgData pkgData;
    protected final List<Result> updated = new ArrayList<Result>();
    protected final List<String> removed = new ArrayList<String>();
    protected final List<String> modelTypeIds;
    protected final boolean isFullBuild;

    public RModelIndexOrder(RProject rProject, List<String> modelTypeIds, boolean isFullBuild) {
        this.rProject = (RProjectNature)rProject;
        this.projectName = rProject.getProject().getName();
        this.modelTypeIds = modelTypeIds;
        this.isFullBuild = isFullBuild;
    }

    protected Result createResult(IRSourceUnit sourceUnit, IRModelInfo model) {
        if (model == null) {
            return null;
        }
        IRFrameInSource topFrame = model.getTopFrame();
        List<? extends IRLangElement> children = topFrame.getModelChildren(null);
        ArrayList<IRLangElement> exports = new ArrayList<IRLangElement>(children.size());
        RUnitElement root = new RUnitElement(sourceUnit, exports);
        for (IRLangElement iRLangElement : children) {
            int n = iRLangElement.getElementType();
            switch (n & 0xF00) {
                case 1280: {
                    exports.add(new ExportedRMethod((IRLangElement)root, (IRMethod)iRLangElement));
                    break;
                }
                case 1024: {
                    exports.add(new ExportedRClass((IRLangElement)root, (IRClass)iRLangElement));
                    break;
                }
                case 1536: {
                    exports.add(new ExportedRElement(root, iRLangElement));
                    break;
                }
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(model.getTopFrame().getAllAccessNames());
        Map<String, ? extends IRFrame> frames = model.getReferencedFrames();
        for (IRFrame iRFrame : frames.values()) {
            hashSet.addAll(((IRFrameInSource)iRFrame).getAllAccessNames());
        }
        return new Result(root, hashSet);
    }

    protected void addRemovedUnit(String unitId) {
        if (!this.isFullBuild) {
            this.removed.add(unitId);
        }
    }

    protected static class Result {
        public final String unitId;
        public final RUnitElement exportedElement;
        public final Set<String> defaultNames;

        public Result(RUnitElement root, Set<String> defaultNames) {
            this.unitId = root.getId();
            this.exportedElement = root;
            this.defaultNames = defaultNames;
        }
    }
}

