/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.io.BufferedReader;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.internal.r.core.builder.RPkgData;
import org.eclipse.statet.r.core.RBuildpaths;

public class RPkgReconciler {
    private static final String DESCRIPTION_PACKAGE_FIELD = "Package:";
    private static final String[] PROBLEM_ARGUMENT_NAMES = new String[]{"severity", "message"};

    public RPkgData parsePkgData(IContainer pkgRoot, MultiStatus status, SubMonitor m) {
        RPkgData result;
        block5: {
            result = new RPkgData();
            try {
                IProject project = pkgRoot.getProject();
                if (!pkgRoot.exists()) {
                    IMarker marker = project.createMarker("org.eclipse.statet.r.resourceMarkers.BuildpathProblem");
                    marker.setAttributes(new String[]{"severity", "message", "location"}, new Object[]{2, NLS.bind((String)"R package folder ''{0}'' is missing.", (Object)pkgRoot.getProjectRelativePath()), "R Project Configuration"});
                    return result;
                }
                IFile file = pkgRoot.getFile(RBuildpaths.PKG_DESCRIPTION_FILE_PATH);
                if (file.exists()) {
                    FileUtil.ReadTextFileOperation fileOp = FileUtil.getFileUtil((Object)file).createReadTextFileOp(new FileUtil.ReaderAction(){

                        public void run(BufferedReader reader, IProgressMonitor monitor) throws IOException, CoreException {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                if (!line.startsWith(RPkgReconciler.DESCRIPTION_PACKAGE_FIELD)) continue;
                                String value = line.substring(RPkgReconciler.DESCRIPTION_PACKAGE_FIELD.length()).trim();
                                if (!value.isEmpty()) {
                                    result.setPkgName(value);
                                }
                                return;
                            }
                        }
                    });
                    fileOp.doOperation((IProgressMonitor)m);
                    if (result.getPkgName() == null) {
                        IMarker marker = file.createMarker("org.eclipse.statet.r.resourceMarkers.RModelProblem");
                        marker.setAttributes(PROBLEM_ARGUMENT_NAMES, new Object[]{2, "The declaration of 'Package' (R package name) is missing."});
                    }
                    break block5;
                }
                IMarker marker = pkgRoot.createMarker("org.eclipse.statet.r.resourceMarkers.RModelProblem");
                marker.setAttributes(PROBLEM_ARGUMENT_NAMES, new Object[]{2, "'DESCRIPTION' file for R package is missing."});
                return result;
            }
            catch (CoreException e) {
                status.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)"An error occurred when parsing R package ''DESCRIPTION'' file ''{0}''.", (Object)pkgRoot.getFullPath().toString()), (Throwable)e));
            }
        }
        return result;
    }

    private String checkRPkgName(String pkgName) {
        if (pkgName != null) {
            return pkgName.intern();
        }
        return null;
    }
}

