/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer;

import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.data.IDataProvider;
import org.eclipse.statet.ecommons.waltable.data.ISpanningDataProvider;
import org.eclipse.statet.ecommons.waltable.layer.DataLayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.cell.DataCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCellDim;
import org.eclipse.statet.ecommons.waltable.layer.cell.LayerCellDim;

public class SpanningDataLayer
extends DataLayer {
    public SpanningDataLayer(ISpanningDataProvider dataProvider, long columnIdCat, int defaultColumnWidth, long rowIdCat, int defaultRowHeight) {
        super((IDataProvider)dataProvider, columnIdCat, defaultColumnWidth, rowIdCat, defaultRowHeight);
    }

    @Override
    public ISpanningDataProvider getDataProvider() {
        return (ISpanningDataProvider)super.getDataProvider();
    }

    @Override
    public ILayerCell getCellByPosition(long columnPosition, long rowPosition) {
        ILayerDim hDim = this.getDim(Orientation.HORIZONTAL);
        ILayerDim vDim = this.getDim(Orientation.VERTICAL);
        long columnId = hDim.getPositionId(columnPosition, columnPosition);
        long rowId = vDim.getPositionId(rowPosition, rowPosition);
        DataCell dataCell = this.getDataProvider().getCellByPosition(columnPosition, rowPosition);
        return new DataLayer.DataLayerCell(this, (ILayerCellDim)new LayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition, dataCell.getColumnPosition(), dataCell.getColumnSpan()), (ILayerCellDim)new LayerCellDim(Orientation.VERTICAL, rowId, rowPosition, dataCell.getRowPosition(), dataCell.getRowSpan()));
    }
}

