/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.editors.RDoubleCommentAction;
import org.eclipse.statet.internal.r.ui.editors.REditorTemplatesPage;
import org.eclipse.statet.internal.r.ui.editors.ROutlinePage;
import org.eclipse.statet.internal.r.ui.editors.RStripCommentsHandler;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.IModelManager;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractMarkOccurrencesProvider;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceFragmentEditorInput;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1OutlinePage;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingProvider;
import org.eclipse.statet.r.core.IRCoreAccess;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.rsource.ast.FDef;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.source.IRDocumentConstants;
import org.eclipse.statet.r.core.source.RDocumentContentInfo;
import org.eclipse.statet.r.ui.RUIHelp;
import org.eclipse.statet.r.ui.editors.IRSourceEditor;
import org.eclipse.statet.r.ui.editors.RCorrectIndentHandler;
import org.eclipse.statet.r.ui.editors.RDefaultFoldingProvider;
import org.eclipse.statet.r.ui.editors.REditorOptions;
import org.eclipse.statet.r.ui.editors.RMarkOccurrencesLocator;
import org.eclipse.statet.r.ui.sourceediting.InsertAssignmentHandler;
import org.eclipse.statet.r.ui.sourceediting.RSourceViewerConfiguration;
import org.eclipse.statet.r.ui.sourceediting.RSourceViewerConfigurator;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.templates.ITemplatesPage;

public class REditor
extends SourceEditor1
implements IRSourceEditor {
    private static final ImList<String> KEY_CONTEXTS = ImCollections.newIdentityList((Object)"org.eclipse.statet.r.contexts.REditor");
    private static final ImList<String> CONTEXT_IDS = ImCollections.concatList((Collection)ACTION_SET_CONTEXT_IDS, KEY_CONTEXTS);
    private RSourceViewerConfigurator rConfig;
    private IContextProvider helpContextProvider;

    public REditor() {
        super(RCore.R_CONTENT_TYPE);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setHelpContextId("org.eclipse.statet.r.ui.r_editor");
        this.setEditorContextMenuId("org.eclipse.statet.r.menus.REditorContextMenu");
        this.setRulerContextMenuId("org.eclipse.statet.r.menus.REditorRulerMenu");
    }

    protected SourceEditorViewerConfigurator createConfiguration() {
        this.setDocumentProvider((IDocumentProvider)RUIPlugin.getInstance().getRDocumentProvider());
        this.enableStructuralFeatures((IModelManager)RModel.getRModelManager(), (Preference)REditorOptions.FOLDING_ENABLED_PREF, (Preference)REditorOptions.PREF_MARKOCCURRENCES_ENABLED);
        IRCoreAccess initAccess = RCore.WORKBENCH_ACCESS;
        this.rConfig = new RSourceViewerConfigurator(initAccess, new RSourceViewerConfiguration((DocContentSections)RDocumentContentInfo.INSTANCE, 0, this, null, null, null));
        return this.rConfig;
    }

    protected SourceEditorViewerConfigurator createInfoConfigurator() {
        return new RSourceViewerConfigurator(this.getRCoreAccess(), new RSourceViewerConfiguration(0, null, SharedUIResources.getColors()));
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof ISourceFragmentEditorInput) {
            this.setDocumentProvider((IDocumentProvider)RUIPlugin.getInstance().getRFragmentDocumentProvider());
            this.overwriteTitleImage(input.getImageDescriptor());
        } else {
            this.setDocumentProvider((IDocumentProvider)RUIPlugin.getInstance().getRDocumentProvider());
            this.overwriteTitleImage(null);
        }
    }

    protected Image getDefaultImage() {
        return RUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.r.ui/image/obj/r_script");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        SourceViewer viewer = (SourceViewer)this.getSourceViewer();
        this.helpContextProvider = RUIHelp.createEnrichedRHelpContextProvider((IWorkbenchPart3)this, "org.eclipse.statet.r.ui.r_editor");
        viewer.getTextWidget().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(REditor.this.helpContextProvider.getContext(null));
            }
        });
    }

    protected ISourceEditorAddon createCodeFoldingProvider() {
        return new FoldingEditorAddon((FoldingProvider)new RDefaultFoldingProvider());
    }

    protected ISourceEditorAddon createMarkOccurrencesProvider() {
        return new MarkOccurrencesProvider(this);
    }

    @Override
    public IRSourceUnit getSourceUnit() {
        return (IRSourceUnit)super.getSourceUnit();
    }

    @Override
    public IRCoreAccess getRCoreAccess() {
        return this.rConfig.getRCoreAccess();
    }

    protected void setupConfiguration(IEditorInput newInput) {
        super.setupConfiguration(newInput);
        IRSourceUnit su = this.getSourceUnit();
        this.rConfig.setSource(su != null ? su.getRCoreAccess() : RCore.WORKBENCH_ACCESS);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if ("tabWidth".equals(event.getProperty()) || "spacesForTabs".equals(event.getProperty())) {
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return false;
    }

    protected Collection<String> getContextIds() {
        return CONTEXT_IDS;
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
        super.collectContextMenuPreferencePages(pageIds);
        pageIds.add("org.eclipse.statet.r.preferencePages.REditorOptions");
        pageIds.add("org.eclipse.statet.r.preferencePages.RTextStyles");
        pageIds.add("org.eclipse.statet.r.preferencePages.REditorTemplates");
        pageIds.add("org.eclipse.statet.r.preferencePages.RCodeStyle");
    }

    protected void createActions() {
        super.createActions();
        IHandlerService handlerService = (IHandlerService)this.getServiceLocator().getService(IHandlerService.class);
        Object handler = new InsertAssignmentHandler(this);
        handlerService.activateHandler("org.eclipse.statet.ltk.commands.InsertAssignment", (IHandler)handler);
        this.markAsStateDependentHandler((IHandler2)handler, true);
        RDoubleCommentAction action = new RDoubleCommentAction(this, this.getRCoreAccess());
        this.setAction(action.getId(), (IAction)action);
        this.markAsStateDependentAction(action.getId(), true);
        handler = new RStripCommentsHandler(this);
        handlerService.activateHandler("org.eclipse.statet.ltk.commands.StripComments", (IHandler)handler);
    }

    protected IHandler2 createCorrectIndentHandler() {
        RCorrectIndentHandler handler = new RCorrectIndentHandler(this);
        this.markAsStateDependentHandler((IHandler2)handler, true);
        return handler;
    }

    protected void editorContextMenuAboutToShow(IMenuManager m) {
        super.editorContextMenuAboutToShow(m);
        IRSourceUnit su = this.getSourceUnit();
        m.insertBefore("additions", (IContributionItem)new Separator("search"));
        m.insertBefore("additions", (IContributionItem)new Separator("stat.submit"));
        IContributionItem additions = m.find("additions");
        if (additions != null) {
            additions.setVisible(false);
        }
        m.remove("ShiftRight");
        m.remove("ShiftLeft");
        m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.statet.r.commands.SubmitSelectionToR", 8)));
        m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.statet.r.commands.SubmitUptoSelectionToR", 8)));
        if (su != null && !su.isReadOnly()) {
            m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.statet.r.commands.SubmitSelectionToR_PasteOutput", 8)));
        }
    }

    protected IRegion getRangeToReveal(ISourceUnitModelInfo modelInfo, ISourceStructElement element) {
        FDef def = (FDef)element.getAdapter(FDef.class);
        if (def != null) {
            RAstNode cont = def.getContChild();
            int offset = element.getSourceRange().getStartOffset();
            int length = cont.getStartOffset() - offset;
            if (cont.getLength() > 0) {
                ++length;
            }
            return new Region(offset, length);
        }
        return null;
    }

    protected SourceEditor1OutlinePage createOutlinePage() {
        return new ROutlinePage(this);
    }

    protected ITemplatesPage createTemplatesPage() {
        return new REditorTemplatesPage(this);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.navigator.ProjectExplorer", "org.eclipse.ui.views.ContentOutline", "org.eclipse.statet.r.views.RHelp"};
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == REnv.class) {
            return (T)this.getRCoreAccess().getREnv();
        }
        if (adapterType == IContextProvider.class) {
            return (T)this.helpContextProvider;
        }
        return (T)super.getAdapter(adapterType);
    }

    private static class MarkOccurrencesProvider
    extends AbstractMarkOccurrencesProvider {
        private final RMarkOccurrencesLocator locator = new RMarkOccurrencesLocator();

        public MarkOccurrencesProvider(SourceEditor1 editor) {
            super(editor, IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT);
        }

        protected void doUpdate(AbstractMarkOccurrencesProvider.RunData run, ISourceUnitModelInfo info, AstSelection astSelection, ITextSelection orgSelection) throws BadLocationException, BadPartitioningException, UnsupportedOperationException {
            this.locator.run(run, info, astSelection, orgSelection);
        }
    }
}

