/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class RVersion
implements Comparable<RVersion> {
    private final int major;
    private final int minor;
    private final int patch;
    private final String build;
    private transient @Nullable String versionString;
    private transient int hash;

    private static int parseInt(String value, String componentName) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.valueOf(componentName) + "= '" + value + "'", e);
        }
    }

    private static void validateInt(int value, String componentName) {
        if (value < 0) {
            throw new IllegalArgumentException(String.valueOf(componentName) + "= " + value);
        }
    }

    public RVersion(int major, int minor, int micro, @Nullable String qualifier) {
        this.major = major;
        this.minor = minor;
        this.patch = micro;
        this.build = (String)ObjectUtils.nonNullElse((Object)qualifier, (Object)"");
        this.validate();
    }

    public RVersion(int major, int minor, int path) {
        this(major, minor, path, null);
    }

    public RVersion(String version) {
        int major = 0;
        int minor = 0;
        int patch = 0;
        String build = "";
        String[] components = version.split("\\.", 4);
        if (components.length == 0 || components[0].isEmpty()) {
            throw new IllegalArgumentException("version= '" + version + "'");
        }
        major = RVersion.parseInt(components[0], "major");
        if (components.length >= 2) {
            minor = RVersion.parseInt(components[1], "minor");
            if (components.length >= 3) {
                patch = RVersion.parseInt(components[2], "patch");
                if (components.length >= 4) {
                    build = components[3];
                }
            }
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
        this.validate();
    }

    private void validate() {
        RVersion.validateInt(this.major, "major");
        RVersion.validateInt(this.minor, "minor");
        RVersion.validateInt(this.patch, "patch");
        int i = 0;
        while (i < this.build.length()) {
            char c = this.build.charAt(i);
            if (!Character.isDefined(c) || c == ' ') {
                throw new IllegalArgumentException("build= " + this.build);
            }
            ++i;
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.patch;
    }

    public String getBuild() {
        return this.build;
    }

    public int hashCode() {
        int h = this.hash;
        if (h != 0) {
            return h;
        }
        h = 527;
        h = 31 * h + this.major;
        h = 31 * h + this.minor;
        h = 31 * h + this.patch;
        this.hash = h = 31 * h + this.build.hashCode();
        return this.hash;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RVersion) {
            RVersion other = (RVersion)object;
            return this.major == other.major && this.minor == other.minor && this.patch == other.patch && this.build.equals(other.build);
        }
        return false;
    }

    @Override
    public int compareTo(RVersion other) {
        if (this == other) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.patch - other.patch;
        if (result != 0) {
            return result;
        }
        return this.build.compareTo(other.build);
    }

    public String toString() {
        String s = this.versionString;
        if (s != null) {
            return s;
        }
        StringBuilder result = new StringBuilder(20 + this.build.length());
        result.append(this.major);
        result.append('.');
        result.append(this.minor);
        result.append('.');
        result.append(this.patch);
        if (!this.build.isEmpty()) {
            result.append('.');
            result.append(this.build);
        }
        this.versionString = result.toString();
        return this.versionString;
    }
}

