/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.IOException;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.RjsStatus;

public final class MainCtrlCmdItem
extends MainCmdItem {
    public static final byte OP_FINISH_TASK = 2;
    private final byte op;

    public MainCtrlCmdItem(byte op, int options) {
        this.op = op;
        this.options = options | Integer.MIN_VALUE;
    }

    public MainCtrlCmdItem(RJIO in) throws IOException {
        this.requestId = in.readInt();
        this.options = in.readInt();
        this.op = in.readByte();
    }

    @Override
    public void writeExternal(RJIO out) throws IOException {
        out.writeInt(this.requestId);
        out.writeInt(this.options);
        out.writeByte(this.op);
    }

    @Override
    public byte getCmdType() {
        return 16;
    }

    @Override
    public byte getOp() {
        return this.op;
    }

    @Override
    public void setAnswer(RjsStatus status) {
        this.options = this.options & 0xF00FFFFF | status.getSeverity() << 20;
    }

    @Override
    public boolean isOK() {
        return (this.options & 0xF00000) == 0;
    }

    @Override
    public RjsStatus getStatus() {
        return null;
    }

    @Override
    public String getDataText() {
        return null;
    }

    @Override
    public boolean testEquals(MainCmdItem other) {
        if (!(other instanceof MainCtrlCmdItem)) {
            return false;
        }
        MainCtrlCmdItem otherItem = (MainCtrlCmdItem)other;
        return this.getOp() == otherItem.getOp() && this.options == otherItem.options;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("MainCtrlCmdItem ");
        switch (this.op) {
            case 2: {
                sb.append("FINISH_TASK");
                break;
            }
            default: {
                sb.append(this.op);
            }
        }
        sb.append("\n\t").append("options= 0x").append(Integer.toHexString(this.options));
        return sb.toString();
    }
}

