/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog.translationfile.directorychooser;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.nlsDirChooser.AbstractNlsTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CompareableFolder
extends AbstractNlsTreeItem {
    private IFolder m_folder;
    private TreeSet<AbstractNlsTreeItem> m_children = new TreeSet();
    private boolean m_loaded;

    public CompareableFolder(IFolder folder) {
        this.m_folder = folder;
    }

    public IFolder getFolder() {
        return this.m_folder;
    }

    @Override
    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    @Override
    public boolean isLoaded() {
        return this.m_loaded;
    }

    @Override
    public boolean hasChildren() {
        return !this.m_children.isEmpty();
    }

    @Override
    public String getText() {
        return this.getFolder().getName();
    }

    public void setLoaded(boolean loaded) {
        this.m_loaded = loaded;
    }

    public void addChild(AbstractNlsTreeItem child) {
        this.m_children.add(child);
    }

    public void removeChild(AbstractNlsTreeItem child) {
        this.m_children.remove(child);
    }

    public void unload() {
        this.m_children.clear();
    }

    @Override
    public Set<AbstractNlsTreeItem> getChildren() {
        return this.m_children;
    }
}

