/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog.nlsDirChooser;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.nlsDirChooser.AbstractNlsTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CompareablePath
extends AbstractNlsTreeItem {
    private IPath m_path;
    private TreeSet<AbstractNlsTreeItem> m_children = new TreeSet();
    private boolean m_loaded;

    public CompareablePath(IPath path) {
        this.m_path = path;
    }

    public IPath getPath() {
        return this.m_path;
    }

    @Override
    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    @Override
    public boolean isLoaded() {
        return this.m_loaded;
    }

    @Override
    public boolean hasChildren() {
        return !this.m_children.isEmpty();
    }

    @Override
    public String getText() {
        return this.getPath().lastSegment();
    }

    public void setLoaded(boolean loaded) {
        this.m_loaded = loaded;
    }

    public void addChild(AbstractNlsTreeItem child) {
        this.m_children.add(child);
    }

    public void removeChild(AbstractNlsTreeItem child) {
        this.m_children.remove(child);
    }

    public void unload() {
        this.m_children.clear();
    }

    @Override
    public Set<AbstractNlsTreeItem> getChildren() {
        return this.m_children;
    }
}

