/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model.workspace.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.INlsFolder;
import org.eclipse.scout.nls.sdk.internal.model.workspace.InheritedNlsEntry;
import org.eclipse.scout.nls.sdk.internal.model.workspace.NlsType;
import org.eclipse.scout.nls.sdk.internal.model.workspace.project.NlsFileProvider;
import org.eclipse.scout.nls.sdk.internal.model.workspace.translationfile.WorkspaceTranslationFile;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProjectListener;
import org.eclipse.scout.nls.sdk.model.workspace.project.NlsProjectEvent;
import org.eclipse.scout.nls.sdk.model.workspace.translationFile.ITranslationFile;
import org.eclipse.scout.nls.sdk.model.workspace.translationFile.ITranslationFileListener;
import org.eclipse.scout.nls.sdk.model.workspace.translationFile.TranslationFileEvent;

public class NlsProject
implements INlsProject {
    private NlsProject m_parent;
    private EventListenerList m_listeners;
    private ITranslationFileListener m_translationFileListener;
    private OptimisticLock m_translationFileEventLock = new OptimisticLock();
    private NlsFileProvider m_fileProvider = new NlsFileProvider();
    private NlsType m_nlsClass;
    private PropertyChangeListener m_nlsClassPropertyListener;
    private Map<String, NlsEntry> m_entries;
    private String m_hostPluginId;
    private Language m_developerLanguage;

    public NlsProject(IType type, String hostPluginId) {
        this.m_hostPluginId = hostPluginId;
        this.m_listeners = new EventListenerList();
        this.m_translationFileListener = new P_TranslationFileChangedListener();
        this.m_nlsClassPropertyListener = new P_NlsClassPropertyChangeListener();
        if (type == null || !type.exists()) {
            NlsCore.logError("NLS type does not exist!", new Exception());
        } else {
            this.m_nlsClass = new NlsType(type);
            this.m_nlsClass.addPropertyChangeListener(this.m_nlsClassPropertyListener);
            this.updateTranslationFileLocation();
            this.setSuperType(this.m_nlsClass.getSuperType());
        }
    }

    @Override
    public IType[] getReferenceTypes() {
        ArrayList<IType> referenceeTypes = new ArrayList<IType>();
        if (this.m_nlsClass != null) {
            referenceeTypes.add(this.m_nlsClass.getType());
            referenceeTypes.addAll(Arrays.asList(this.m_nlsClass.getAllSuperclasses()));
        }
        return referenceeTypes.toArray(new IType[referenceeTypes.size()]);
    }

    protected void updateTranslationFileLocation() {
        try {
            if (this.m_nlsClass != null && this.m_nlsClass.getType() != null && this.m_nlsClass.getType().exists()) {
                ITranslationFile[] translationFiles;
                ITranslationFile[] iTranslationFileArray = translationFiles = NlsCore.getNlsWorkspace().loadTranslationFiles(this.m_nlsClass, (IProgressMonitor)new NullProgressMonitor());
                int n = translationFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    ITranslationFile file = iTranslationFileArray[n2];
                    this.addTranslationFile(file, (IProgressMonitor)new NullProgressMonitor());
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            NlsCore.logError("could not load tranlstion property files of project: '" + this.getName() + "'", e);
        }
    }

    protected void setSuperType(IType superType) {
        if (superType != null) {
            try {
                this.m_parent = NlsCore.getNlsWorkspace().findNlsProject(superType, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                NlsCore.logError("parent of NLS project '" + this.getName() + "' could not be found. Looked for type '" + superType.getFullyQualifiedName() + "'");
            }
        }
    }

    public void fullRefresh(boolean reloadFiles) {
        this.resetCache();
        if (reloadFiles) {
            ITranslationFile[] iTranslationFileArray = this.m_fileProvider.getFiles();
            int n = iTranslationFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITranslationFile file = iTranslationFileArray[n2];
                file.removeTranslationFileListener(this.m_translationFileListener);
                this.m_fileProvider.remove(file);
                ++n2;
            }
            this.updateTranslationFileLocation();
            this.fireNlsProjectEvent(new NlsProjectEvent(this, 16));
        } else {
            this.fireNlsProjectEvent(new NlsProjectEvent(this, 8));
        }
    }

    @Override
    public ITranslationFile[] getTranslationFiles() {
        return this.m_fileProvider.getFiles();
    }

    public String getHostPluginId() {
        return this.m_hostPluginId;
    }

    @Override
    public String getName() {
        return this.m_hostPluginId;
    }

    public void setClass(NlsType clazz, IProgressMonitor monitor) {
        this.m_nlsClass = clazz;
    }

    @Override
    public String getFullyQuallifiedNlsClassName() {
        return this.m_nlsClass.getType().getFullyQualifiedName();
    }

    @Override
    public NlsType getNlsType() {
        return this.m_nlsClass;
    }

    public void addTranslationFile(ITranslationFile file, IProgressMonitor monitor) {
        file.getLanguage().setLocal(true);
        file.addTranslationFileListener(this.m_translationFileListener);
        this.m_fileProvider.addFile(file);
        this.resetCache();
        this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, file, 32));
    }

    public void removeTranslationFile(ITranslationFile file, IProgressMonitor monitor) {
        this.m_fileProvider.remove(file);
        file.removeTranslationFileListener(this.m_translationFileListener);
        this.resetCache();
        this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, file, 64));
    }

    private void resetCache() {
        this.m_entries = null;
    }

    private void cache() {
        if (this.m_entries == null) {
            int n;
            int n2;
            Object[] objectArray;
            this.m_entries = new HashMap<String, NlsEntry>();
            if (this.getParent() != null) {
                objectArray = this.getParent().getAllKeys();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object parentKey = objectArray[n];
                    this.m_entries.put((String)parentKey, new InheritedNlsEntry(this.getParent().getEntry((String)parentKey), (INlsProject)this));
                    ++n;
                }
            }
            objectArray = this.getAllTranslationFiles();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object file = objectArray[n];
                String[] stringArray = file.getAllKeys();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String key = stringArray[n4];
                    NlsEntry nlsEntry = this.m_entries.get(key);
                    if (nlsEntry == null) {
                        nlsEntry = new NlsEntry(key, this);
                        this.m_entries.put(key, nlsEntry);
                    }
                    if (nlsEntry.getType() == 1) {
                        nlsEntry.addTranslation(file.getLanguage(), file.getTranslation(key));
                    } else {
                        NlsCore.logError("NLS key: '" + nlsEntry.getKey() + "' is inherited in the project: '" + this.getJavaProject().getElementName() + "' and can not be overwritten");
                    }
                    ++n4;
                }
                ++n;
            }
        }
    }

    public ITranslationFile[] getAllTranslationFiles() {
        return this.m_fileProvider.getSortedFiles();
    }

    public IJavaProject getJavaProject() {
        return this.m_nlsClass.getJavaProject();
    }

    @Override
    public IProject getProject() {
        return this.m_nlsClass.getJavaProject().getProject();
    }

    public ITranslationFile getTranslationFile(Language language) {
        return this.m_fileProvider.getFile(language);
    }

    @Override
    public String[] getAllKeys() {
        this.cache();
        return this.m_entries.keySet().toArray(new String[this.m_entries.size()]);
    }

    @Override
    public INlsEntry getEntry(String key) {
        this.cache();
        return this.m_entries.get(key);
    }

    @Override
    public INlsEntry[] getEntries(String prefix, boolean caseSensitive) {
        this.cache();
        if (StringUtility.hasText((String)prefix)) {
            String compareablePrefix = prefix;
            if (!caseSensitive) {
                compareablePrefix = compareablePrefix.toLowerCase();
            }
            ArrayList<INlsEntry> entries = new ArrayList<INlsEntry>();
            Iterator<String> iterator = this.m_entries.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String compareKey = key = iterator.next();
                if (!caseSensitive) {
                    compareKey = compareKey.toLowerCase();
                }
                if (!compareKey.startsWith(compareablePrefix)) continue;
                entries.add(this.m_entries.get(key));
            }
            return entries.toArray(new INlsEntry[entries.size()]);
        }
        return this.m_entries.values().toArray(new INlsEntry[this.m_entries.values().size()]);
    }

    @Override
    public INlsEntry[] getAllEntries() {
        this.cache();
        return this.m_entries.values().toArray(new INlsEntry[this.m_entries.size()]);
    }

    @Override
    public NlsProject getParent() {
        return this.m_parent;
    }

    @Override
    public Language getDevelopmentLanguage() {
        if (this.m_developerLanguage == null) {
            Language lang = new Language(Locale.getDefault());
            if (!(this.containsLanguage(lang) || this.containsLanguage(lang = new Language(new Locale(lang.getLocale().getLanguage(), lang.getLocale().getCountry()))) || this.containsLanguage(lang = new Language(new Locale(lang.getLocale().getLanguage()))))) {
                lang = Language.LANGUAGE_DEFAULT;
            }
            this.m_developerLanguage = lang;
        }
        return this.m_developerLanguage;
    }

    public void setParent(NlsProject parent, IProgressMonitor monitor) {
        this.m_parent = parent;
        this.m_parent.addProjectListener(new P_ParentListener());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateKey(INlsEntry entry, String newKey, IProgressMonitor monitor) {
        if (this.m_entries == null) return;
        NlsProjectEvent multiEvent = new NlsProjectEvent(this);
        try {
            this.m_translationFileEventLock.acquire();
            monitor.beginTask("update Key", -1);
            NlsEntry originalEntry = this.m_entries.remove(entry.getKey());
            if (originalEntry == null) {
                NlsCore.logError("The nls entry with the key '" + entry.getKey() + "' can not be found in project '" + this.getProject().getName() + "'", new Exception());
                return;
            }
            if (originalEntry.getType() == 2) {
                NlsCore.logError("The inherited NLS entry '" + originalEntry.getKey() + "' can not be modified", new Exception());
                return;
            }
            multiEvent.addChildEvent(new NlsProjectEvent((INlsProject)this, originalEntry, 2));
            for (Map.Entry<Language, String> e : entry.getAllTranslations().entrySet()) {
                ITranslationFile file = this.getTranslationFile(e.getKey());
                if (file == null) continue;
                file.updateKey(entry.getKey(), newKey, monitor);
            }
            NlsEntry newEntry = new NlsEntry(originalEntry);
            newEntry.setKey(newKey);
            this.m_entries.put(newEntry.getKey(), newEntry);
            multiEvent.addChildEvent(new NlsProjectEvent((INlsProject)this, newEntry, 1));
            return;
        }
        finally {
            this.m_translationFileEventLock.release();
        }
    }

    @Override
    public void updateRow(INlsEntry row) {
        this.updateRow(row, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void updateRow(INlsEntry row, IProgressMonitor monitor) {
        if (this.m_entries != null) {
            try {
                this.m_translationFileEventLock.acquire();
                NlsEntry existingEntry = this.m_entries.get(row.getKey());
                if (existingEntry != null) {
                    if (existingEntry.getType() == 2) {
                        NlsCore.logError("The inherited NLS entry '" + existingEntry.getKey() + "' can not be modified", new Exception());
                        return;
                    }
                    this.updateExistingRowInternal(existingEntry, row, monitor);
                } else {
                    this.createNewRowInternal(row, monitor);
                }
            }
            finally {
                this.m_translationFileEventLock.release();
            }
        }
    }

    private void createNewRowInternal(INlsEntry row, IProgressMonitor monitor) {
        NlsEntry newRow = new NlsEntry(row);
        this.m_entries.put(newRow.getKey(), newRow);
        for (Map.Entry<Language, String> entry : newRow.getAllTranslations().entrySet()) {
            ITranslationFile file = this.getTranslationFile(entry.getKey());
            if (file == null) continue;
            file.updateText(newRow.getKey(), entry.getValue(), monitor);
        }
        this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, newRow, 1));
    }

    private void updateExistingRowInternal(NlsEntry existingRow, INlsEntry row, IProgressMonitor monitor) {
        boolean updated = false;
        for (Map.Entry<Language, String> entry : row.getAllTranslations().entrySet()) {
            ITranslationFile file;
            String existingTranslation = existingRow.getTranslation(entry.getKey());
            if (!CompareUtility.notEquals((Object)existingTranslation, (Object)entry.getValue()) || (file = this.getTranslationFile(entry.getKey())) == null) continue;
            updated = true;
            file.updateText(row.getKey(), entry.getValue(), monitor);
            existingRow.addTranslation(entry.getKey(), entry.getValue());
        }
        if (updated) {
            this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, existingRow, 4));
        }
    }

    private void handleParentRowAdded(INlsEntry superRow) {
        if (this.m_entries != null) {
            NlsEntry entry = this.m_entries.get(superRow.getKey());
            if (entry != null) {
                NlsCore.logError("NLS entry with key:'" + superRow.getKey() + "' already exists in project:'" + this.getProject().getName() + "'", new Exception());
            } else {
                entry = new InheritedNlsEntry(superRow, (INlsProject)this);
                this.m_entries.put(entry.getKey(), entry);
                this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, entry, 1));
            }
        }
    }

    private void handleParentRowRemoved(INlsEntry superRow) {
        NlsEntry removedEntry;
        if (this.m_entries != null && (removedEntry = this.m_entries.remove(superRow.getKey())) != null) {
            this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, removedEntry, 2));
        }
    }

    public void removeRow(String key) {
        NlsEntry row = this.m_entries.remove(key);
        Assert.isNotNull((Object)row);
        this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, row, 2));
    }

    private void handleParentRowModified(INlsEntry superRow) {
        if (this.m_entries != null) {
            NlsEntry entry = this.m_entries.get(superRow.getKey());
            if (entry == null) {
                NlsCore.logError("NLS entry with key:'" + superRow.getKey() + "' not found in the project:'" + this.getProject().getName() + "'", new Exception());
                return;
            }
            entry.update(superRow);
            this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, entry, 4));
        }
    }

    @Override
    public void createTranslationFile(Language language, INlsFolder folder, IProgressMonitor monitor) throws CoreException {
        String fileName = NlsCore.getLocalizedPropertiesFileName(this.getNlsType().getTranslationsPrefix(), language);
        IFile file = folder.getFolder().getFile((IPath)new Path(fileName));
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, monitor);
        }
        this.addTranslationFile(new WorkspaceTranslationFile(file), monitor);
    }

    public void handleReferenceCountUpdated(String key, int value) {
        Assert.isNotNull((Object)key);
        NlsEntry row = this.m_entries.get(key);
        if (row != null) {
            row.setReferenceCount(value);
        }
    }

    @Override
    public Language[] getAllLanguages() {
        return this.m_fileProvider.getAllLanguages();
    }

    @Override
    public Language getBestMatchingProjectLanguage(Language language) {
        if (this.containsLanguage(language)) {
            return language;
        }
        Locale locale = new Locale(language.getLocale().getLanguage(), language.getLocale().getCountry());
        Language bestMatch = new Language(locale);
        if (this.containsLanguage(bestMatch)) {
            return bestMatch;
        }
        locale = new Locale(language.getLocale().getLanguage());
        bestMatch = new Language(locale);
        if (this.containsLanguage(bestMatch)) {
            return bestMatch;
        }
        return Language.LANGUAGE_DEFAULT;
    }

    @Override
    public boolean containsLanguage(Language languge) {
        return this.m_fileProvider.containsFile(languge);
    }

    public boolean containsLanguageLocal(Language language) {
        return this.m_fileProvider.containsFile(language);
    }

    public boolean containsKey(String key) {
        return this.m_entries.containsKey(key);
    }

    @Override
    public void addProjectListener(INlsProjectListener listener) {
        this.m_listeners.add(INlsProjectListener.class, (EventListener)listener);
    }

    @Override
    public void removeProjectListener(INlsProjectListener listener) {
        this.m_listeners.remove(INlsProjectListener.class, (EventListener)listener);
    }

    protected void fireNlsProjectEvent(NlsProjectEvent event) {
        INlsProjectListener[] iNlsProjectListenerArray = (INlsProjectListener[])this.m_listeners.getListeners(INlsProjectListener.class);
        int n = iNlsProjectListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            INlsProjectListener listener = iNlsProjectListenerArray[n2];
            listener.notifyProjectChanged(event);
            ++n2;
        }
    }

    private void handleTranlationFileChanged(TranslationFileEvent event) {
        try {
            if (this.m_translationFileEventLock.acquire()) {
                HashMap<INlsEntry, NlsProjectEvent> addEvents = new HashMap<INlsEntry, NlsProjectEvent>();
                HashMap<INlsEntry, NlsProjectEvent> modifyEvents = new HashMap<INlsEntry, NlsProjectEvent>();
                HashMap<INlsEntry, NlsProjectEvent> removeEvents = new HashMap<INlsEntry, NlsProjectEvent>();
                this.handleTranslationFileChangedRec(addEvents, modifyEvents, removeEvents, event);
                NlsProjectEvent multiEvent = new NlsProjectEvent(this);
                for (NlsProjectEvent e : addEvents.values()) {
                    multiEvent.addChildEvent(e);
                }
                for (NlsProjectEvent e : removeEvents.values()) {
                    multiEvent.addChildEvent(e);
                }
                for (NlsProjectEvent e : modifyEvents.values()) {
                    multiEvent.addChildEvent(e);
                }
                if (multiEvent.getChildEvents().length == 1) {
                    this.fireNlsProjectEvent(multiEvent.getChildEvents()[0]);
                } else if (multiEvent.getChildEvents().length > 1) {
                    this.fireNlsProjectEvent(multiEvent);
                }
            }
        }
        finally {
            this.m_translationFileEventLock.release();
        }
    }

    private void handleTranslationFileChangedRec(Map<INlsEntry, NlsProjectEvent> addEvents, Map<INlsEntry, NlsProjectEvent> modifyEvents, Map<INlsEntry, NlsProjectEvent> removeEvents, TranslationFileEvent event) {
        if (event.isMulti()) {
            TranslationFileEvent[] translationFileEventArray = event.getSubEvents();
            int n = translationFileEventArray.length;
            int n2 = 0;
            while (n2 < n) {
                TranslationFileEvent e = translationFileEventArray[n2];
                this.handleTranslationFileChangedRec(addEvents, modifyEvents, removeEvents, e);
                ++n2;
            }
        } else {
            String key = event.getKey();
            String translation = event.getTranslation();
            NlsEntry entry = this.m_entries.get(key);
            switch (event.getType()) {
                case 1: {
                    if (entry == null) {
                        entry = new NlsEntry(key, this);
                        entry.addTranslation(event.getSource().getLanguage(), translation);
                        this.m_entries.put(entry.getKey(), entry);
                        addEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 1));
                        break;
                    }
                    NlsCore.logWarning("translation file fired an add event of the existing NLS entry:'" + entry.getKey() + "'");
                    break;
                }
                case 2: {
                    if (entry == null) break;
                    entry.addTranslation(event.getSource().getLanguage(), null);
                    if (entry.isEmpty()) {
                        this.m_entries.remove(entry.getKey());
                        removeEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 2));
                        modifyEvents.remove(entry);
                        break;
                    }
                    modifyEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 4));
                    break;
                }
                case 4: {
                    if (entry == null) break;
                    entry.addTranslation(event.getSource().getLanguage(), translation);
                    modifyEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 4));
                    break;
                }
                case 1024: {
                    this.fullRefresh(true);
                    break;
                }
            }
        }
    }

    private class P_NlsClassPropertyChangeListener
    implements PropertyChangeListener {
        private P_NlsClassPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("translationFilePrefix".equals(evt.getPropertyName()) || "translationFolderName".equals(evt.getPropertyName())) {
                NlsProject.this.resetCache();
                NlsProject.this.updateTranslationFileLocation();
                NlsProject.this.fireNlsProjectEvent(new NlsProjectEvent(NlsProject.this, 16));
            } else if ("superType".equals(evt.getPropertyName())) {
                NlsProject.this.resetCache();
                NlsProject.this.setSuperType(NlsProject.this.m_nlsClass.getSuperType());
                NlsProject.this.fireNlsProjectEvent(new NlsProjectEvent(NlsProject.this, 16));
            }
        }
    }

    private class P_ParentListener
    implements INlsProjectListener {
        private P_ParentListener() {
        }

        @Override
        public void notifyProjectChanged(NlsProjectEvent event) {
            if (event.isMultiEvent()) {
                NlsProjectEvent[] nlsProjectEventArray = event.getChildEvents();
                int n = nlsProjectEventArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NlsProjectEvent subEvent = nlsProjectEventArray[n2];
                    this.notifyProjectChanged(subEvent);
                    ++n2;
                }
            } else {
                switch (event.getType()) {
                    case 1: {
                        NlsProject.this.handleParentRowAdded(event.getEntry());
                        break;
                    }
                    case 2: {
                        NlsProject.this.handleParentRowRemoved(event.getEntry());
                        break;
                    }
                    case 4: {
                        NlsProject.this.handleParentRowModified(event.getEntry());
                        break;
                    }
                }
            }
        }
    }

    private class P_TranslationFileChangedListener
    implements ITranslationFileListener {
        private P_TranslationFileChangedListener() {
        }

        @Override
        public void translationFileChanged(TranslationFileEvent event) {
            NlsProject.this.handleTranlationFileChanged(event);
        }
    }
}

