/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model.workspace.nlsfile;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.workspace.nlsfile.AbstractNlsFile;

public class WorkspaceNlsFile
extends AbstractNlsFile {
    private IFile m_file;

    public WorkspaceNlsFile(IFile file) throws CoreException {
        super(file.getContents(), file.getName());
        this.m_file = file;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new P_NlsFileChangeListener(), 1);
    }

    public IProject getProject() {
        return this.m_file.getProject();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    private class P_NlsFileChangeListener
    implements IResourceChangeListener {
        private P_NlsFileChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) {
                            IResource resource = delta.getResource();
                            if (resource != null && resource.equals((Object)WorkspaceNlsFile.this.m_file) && WorkspaceNlsFile.this.m_file.exists()) {
                                try {
                                    WorkspaceNlsFile.this.parseInput(WorkspaceNlsFile.this.m_file.getContents(), WorkspaceNlsFile.this.m_file.getFullPath().toString());
                                }
                                catch (CoreException coreException) {
                                    NlsCore.logError("could not open stream to read NLS file :'" + WorkspaceNlsFile.this.m_file.getFullPath() + "'");
                                }
                            }
                            return true;
                        }
                    });
                }
            }
            catch (CoreException e) {
                NlsCore.logWarning(e);
            }
        }
    }
}

