/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model.workspace.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.scout.nls.sdk.internal.model.workspace.manifest.ManifestElement;

public class ManifestEntry {
    private String m_key;
    private List<ManifestElement> m_values = new LinkedList<ManifestElement>();

    public ManifestEntry(String key) {
        this.m_key = key;
    }

    void parse(String textRepresentation) {
        int seperatorIndex = textRepresentation.indexOf(":");
        this.m_key = textRepresentation.substring(0, seperatorIndex - 1).trim();
        String valueText = textRepresentation.substring(seperatorIndex + 1, textRepresentation.length());
        this.parseElements(valueText);
    }

    void parseElements(String valuesText) {
        valuesText = valuesText.replaceAll("\n", "");
        String[] stringArray = valuesText.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            ManifestElement element = new ManifestElement();
            element.parse(value);
            this.m_values.add(element);
            ++n2;
        }
    }

    public void addElement(ManifestElement newElement) {
        boolean inserted = false;
        for (ManifestElement element : this.m_values) {
            if (!element.getValue().equals(newElement.getValue())) continue;
            inserted = true;
            for (Map.Entry<String, String> newProp : newElement.getPropertyMap().entrySet()) {
                element.addProperty(newProp.getKey(), newProp.getValue());
            }
        }
        if (!inserted) {
            this.m_values.add(newElement);
        }
    }

    public String getKey() {
        return this.m_key;
    }

    public Collection<ManifestElement> getElements() {
        return new ArrayList<ManifestElement>(this.m_values);
    }

    public ManifestElement getFirstElement() {
        Assert.isTrue((this.m_values.size() > 0 ? 1 : 0) != 0);
        return this.m_values.get(0);
    }

    public boolean containsElement(String name) {
        for (ManifestElement element : this.m_values) {
            if (!element.getValue().equals(name)) continue;
            return true;
        }
        return false;
    }
}

