/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model;

import java.util.ArrayList;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;

public class TypeHandler {
    private static final TypeHandler instance = new TypeHandler();

    private TypeHandler() {
    }

    public static IType getType(String fullyQualifiedName) throws JavaModelException {
        return instance.getTypeImpl(fullyQualifiedName);
    }

    private IType getTypeImpl(String fullyQualifiedName) throws JavaModelException {
        TreeMap foundTypes;
        block4: {
            foundTypes = new TreeMap();
            try {
                ArrayList<IJavaProject> elements = new ArrayList<IJavaProject>();
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    elements.add(JavaCore.create((IProject)project));
                    ++n2;
                }
                IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements.toArray(new IJavaElement[elements.size()]), (boolean)true);
                new SearchEngine().search(SearchPattern.createPattern((String)fullyQualifiedName, (int)0, (int)0, (int)8), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, new SearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        if (match instanceof TypeDeclarationMatch) {
                            IType type = (IType)match.getElement();
                            if (type.isBinary()) {
                                foundTypes.put(2, type);
                            } else {
                                foundTypes.put(1, type);
                                throw new CoreException(Status.OK_STATUS);
                            }
                        }
                    }
                }, null);
            }
            catch (CoreException e) {
                if (e.getStatus().isOK() && foundTypes.size() > 0) break block4;
                throw new JavaModelException(e);
            }
        }
        if (foundTypes.size() > 0) {
            return (IType)foundTypes.values().iterator().next();
        }
        return null;
    }

    public static IType[] findAllSubtypes(String name, IProgressMonitor monitor) throws JavaModelException {
        return instance.findAllSubtypesImpl(name, monitor);
    }

    private IType[] findAllSubtypesImpl(String name, IProgressMonitor monitor) throws JavaModelException {
        IType superType = this.getTypeImpl(name);
        ITypeHierarchy nlsHierarchy = superType.newTypeHierarchy(monitor);
        return nlsHierarchy.getAllSubtypes(superType);
    }
}

