/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.JavaFileInputReader;
import org.eclipse.scout.nls.sdk.internal.model.ISearchKeyRefListener;

public class SearchAllRefCollector
extends SearchRequestor {
    private HashMap<String, List<SearchMatch>> m_matches = new HashMap();
    private String m_className;
    private List<ISearchKeyRefListener> m_listeners = new LinkedList<ISearchKeyRefListener>();
    private String m_regexp = "\\b[A-Za-z][a-zA-Z0-9_]{0,200}";

    public SearchAllRefCollector(String className) {
        this.m_className = className;
    }

    public void addSearchKeyRefListener(ISearchKeyRefListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeSearchKeyRefListener(ISearchKeyRefListener listener) {
        this.m_listeners.remove(listener);
    }

    public void beginReporting() {
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        if (!(match.getResource() instanceof IFile)) {
            return;
        }
        JavaFileInputReader reader = new JavaFileInputReader((IFile)match.getResource());
        try {
            int in = -1;
            int i = 0;
            while (i < match.getOffset()) {
                in = reader.read();
                ++i;
            }
            if (reader.isCommentBlock()) {
                return;
            }
            try {
                StringBuffer buffer = new StringBuffer();
                while (in >= 0 && in != 59) {
                    in = reader.read();
                    buffer.append((char)in);
                }
                String key = this.findKey(buffer.toString(), match);
                if (key != null) {
                    for (ISearchKeyRefListener listener : this.m_listeners) {
                        listener.keyFound(key);
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                NlsCore.logWarning(e);
            }
        }
    }

    public void endReporting() {
        for (ISearchKeyRefListener listener : this.m_listeners) {
            listener.endSearch();
        }
    }

    private String findKey(String statement, SearchMatch match) {
        int startIndex = (statement = statement.replaceAll("\n", "")).indexOf(this.m_className) + this.m_className.length();
        if (startIndex > 0 && startIndex < statement.length()) {
            if (!(statement = statement.substring(startIndex)).startsWith(".")) {
                return null;
            }
            statement = statement.substring(1);
            Pattern p = Pattern.compile(this.m_regexp);
            Matcher m = p.matcher(statement);
            if (m.find()) {
                return statement.substring(m.start(), m.end());
            }
        }
        return null;
    }
}

