/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.strategy;

import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.instantiator.android.Android23Instantiator;
import org.objenesis.instantiator.android.Android30Instantiator;
import org.objenesis.instantiator.gcj.GCJInstantiator;
import org.objenesis.instantiator.jrockit.JRockit131Instantiator;
import org.objenesis.instantiator.jrockit.JRockitLegacyInstantiator;
import org.objenesis.instantiator.perc.PercInstantiator;
import org.objenesis.instantiator.sun.Sun13Instantiator;
import org.objenesis.instantiator.sun.SunReflectionFactoryInstantiator;
import org.objenesis.instantiator.sun.UnsafeFactoryInstantiator;
import org.objenesis.strategy.BaseInstantiatorStrategy;
import org.objenesis.strategy.PlatformDescription;

public class StdInstantiatorStrategy
extends BaseInstantiatorStrategy {
    public ObjectInstantiator newInstantiatorOf(Class type) {
        if (PlatformDescription.isThisJVM("Java HotSpot")) {
            if (VM_VERSION.startsWith("1.3")) {
                return new Sun13Instantiator(type);
            }
            return new SunReflectionFactoryInstantiator(type);
        }
        if (PlatformDescription.isThisJVM("BEA")) {
            if (VM_VERSION.startsWith("1.3")) {
                return new JRockit131Instantiator(type);
            }
            if (!(!VM_VERSION.startsWith("1.4") || VENDOR_VERSION.startsWith("R") || VM_INFO != null && VM_INFO.startsWith("R25.1") && VM_INFO.startsWith("R25.2"))) {
                return new JRockitLegacyInstantiator(type);
            }
            return new SunReflectionFactoryInstantiator(type);
        }
        if (PlatformDescription.isThisJVM("Dalvik")) {
            if (VENDOR_VERSION.compareTo("1.5.0") < 0) {
                return new Android23Instantiator(type);
            }
            return new Android30Instantiator(type);
        }
        if (PlatformDescription.isThisJVM("GNU libgcj")) {
            return new GCJInstantiator(type);
        }
        if (PlatformDescription.isThisJVM("PERC")) {
            return new PercInstantiator(type);
        }
        return new UnsafeFactoryInstantiator(type);
    }
}

