/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.file;

import java.io.File;
import java.util.Locale;
import java.util.Set;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public final class Matcher {
    public static final String DEEP_TREE_MATCH = "**";
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static final String PATH_SEP = System.getProperty("path.separator");
    private static final boolean ON_NETWARE = Matcher.isNetware();
    private static final boolean ON_DOS = Matcher.isDos();
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.file");
    private static final Log log = LogFactory.getLog(Matcher.class);

    public static boolean matchPath(Set<String[]> patternSet, String str) {
        for (String[] patternTokens : patternSet) {
            if (!Matcher.matchPath(patternTokens, Matcher.tokenizePathAsArray(str), true)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchPath(String pattern, String str) {
        String[] patDirs = Matcher.tokenizePathAsArray(pattern);
        return Matcher.matchPath(patDirs, Matcher.tokenizePathAsArray(str), true);
    }

    public static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        String[] patDirs = Matcher.tokenizePathAsArray(pattern);
        return Matcher.matchPath(patDirs, Matcher.tokenizePathAsArray(str), isCaseSensitive);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean matchPath(String[] tokenizedPattern, String[] strDirs, boolean isCaseSensitive) {
        patIdxStart = 0;
        patIdxEnd = tokenizedPattern.length - 1;
        strIdxStart = 0;
        strIdxEnd = strDirs.length - 1;
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) {
            patDir = tokenizedPattern[patIdxStart];
            if (patDir.equals("**")) break;
            if (!Matcher.match(patDir, strDirs[strIdxStart], isCaseSensitive)) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            i = patIdxStart;
            while (i <= patIdxEnd) {
                if (!tokenizedPattern[i].equals("**")) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxStart <= patIdxEnd) ** GOTO lbl28
        return false;
        while (!(patDir = tokenizedPattern[patIdxEnd]).equals("**")) {
            if (!Matcher.match(patDir, strDirs[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl28:
            // 2 sources

            if (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) continue;
        }
        if (strIdxStart <= strIdxEnd) ** GOTO lbl70
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (!tokenizedPattern[i].equals("**")) {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (tokenizedPattern[i].equals("**")) {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block19: {
                    j = 0;
                    while (j < patLength) {
                        subPat = tokenizedPattern[patIdxStart + j + 1];
                        subStr = strDirs[strIdxStart + i + j];
                        if (Matcher.match(subPat, subStr, isCaseSensitive)) {
                            ++j;
                            continue;
                        }
                        break block19;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl70:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl71:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (!tokenizedPattern[i].equals("**")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean match(String pattern, String str) {
        return Matcher.match(pattern, str, true);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean match(String pattern, String str, boolean caseSensitive) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        i = 0;
        while (i < patArr.length) {
            if (patArr[i] == '*') {
                containsStar = true;
                break;
            }
            ++i;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (ch != '?' && Matcher.different(caseSensitive, ch, strArr[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && Matcher.different(caseSensitive, ch, strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            return Matcher.allStars(patArr, patIdxStart, patIdxEnd);
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && Matcher.different(caseSensitive, ch, strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart <= strIdxEnd) ** GOTO lbl76
        return Matcher.allStars(patArr, patIdxStart, patIdxEnd);
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block20: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (ch == '?' || !Matcher.different(caseSensitive, ch, strArr[strIdxStart + i + j])) {
                            ++j;
                            continue;
                        }
                        break block20;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl76:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl77:
        // 1 sources

        return Matcher.allStars(patArr, patIdxStart, patIdxEnd);
    }

    private static boolean allStars(char[] chars, int start, int end) {
        int i = start;
        while (i <= end) {
            if (chars[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean different(boolean caseSensitive, char ch, char other) {
        return caseSensitive ? ch != other : Character.toUpperCase(ch) != Character.toUpperCase(other);
    }

    public static String[] tokenizePathAsArray(String path) {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("matcher.tokenize", path));
        }
        String root = null;
        if (Matcher.isAbsolutePath(path)) {
            String[] s = Matcher.dissect(path);
            root = s[0];
            path = s[1];
        }
        char sep = File.separatorChar;
        int start = 0;
        int len = path.length();
        int count = 0;
        int pos = 0;
        while (pos < len) {
            if (path.charAt(pos) == sep) {
                if (pos != start) {
                    ++count;
                }
                start = pos + 1;
            }
            ++pos;
        }
        if (len != start) {
            ++count;
        }
        String[] l = new String[count + (root == null ? 0 : 1)];
        if (root != null) {
            l[0] = root;
            count = 1;
        } else {
            count = 0;
        }
        start = 0;
        int pos2 = 0;
        while (pos2 < len) {
            if (path.charAt(pos2) == sep) {
                if (pos2 != start) {
                    String tok = path.substring(start, pos2);
                    l[count++] = tok;
                }
                start = pos2 + 1;
            }
            ++pos2;
        }
        if (len != start) {
            String tok;
            l[count] = tok = path.substring(start);
        }
        return l;
    }

    private static String[] dissect(String path) {
        char sep = File.separatorChar;
        path = path.replace('/', sep).replace('\\', sep);
        String root = null;
        int colon = path.indexOf(58);
        if (colon > 0 && (ON_DOS || ON_NETWARE)) {
            int next = colon + 1;
            root = path.substring(0, next);
            char[] ca = path.toCharArray();
            root = String.valueOf(root) + sep;
            next = ca[next] == sep ? next + 1 : next;
            StringBuilder sbPath = new StringBuilder();
            int i = next;
            while (i < ca.length) {
                if (ca[i] != sep || ca[i - 1] != sep) {
                    sbPath.append(ca[i]);
                }
                ++i;
            }
            path = sbPath.toString();
        } else if (path.length() > 1 && path.charAt(1) == sep) {
            int nextsep = path.indexOf(sep, 2);
            root = (nextsep = path.indexOf(sep, nextsep + 1)) > 2 ? path.substring(0, nextsep + 1) : path;
            path = path.substring(root.length());
        } else {
            root = File.separator;
            path = path.substring(1);
        }
        return new String[]{root, path};
    }

    private static boolean isAbsolutePath(String filename) {
        int len = filename.length();
        if (len == 0) {
            return false;
        }
        char sep = File.separatorChar;
        filename = filename.replace('/', sep).replace('\\', sep);
        char c = filename.charAt(0);
        if (!ON_DOS && !ON_NETWARE) {
            return c == sep;
        }
        if (c == sep) {
            if (!ON_DOS || len <= 4 || filename.charAt(1) != sep) {
                return false;
            }
            int nextsep = filename.indexOf(sep, 2);
            return nextsep > 2 && nextsep + 1 < len;
        }
        int colon = filename.indexOf(58);
        return Character.isLetter(c) && colon == 1 && filename.length() > 2 && filename.charAt(2) == sep || ON_NETWARE && colon > 0;
    }

    private static boolean isNetware() {
        return OS_NAME.indexOf("netware") > -1;
    }

    private static boolean isDos() {
        return PATH_SEP.equals(";") && !Matcher.isNetware();
    }
}

