/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class WARDirContext
extends BaseDirContext {
    private static final Log log = LogFactory.getLog(WARDirContext.class);
    protected ZipFile base = null;
    protected Entry entries = null;

    public WARDirContext() {
    }

    public WARDirContext(Hashtable<String, Object> env) {
        super(env);
    }

    protected WARDirContext(ZipFile base, Entry entries) {
        this.base = base;
        this.entries = entries;
    }

    @Override
    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException(sm.getString("resources.null"));
        }
        if (!docBase.endsWith(".war")) {
            throw new IllegalArgumentException(sm.getString("warResources.notWar"));
        }
        File base = new File(docBase);
        if (!base.exists() || !base.canRead() || base.isDirectory()) {
            throw new IllegalArgumentException(sm.getString("warResources.invalidWar", docBase));
        }
        try {
            this.base = new ZipFile(base);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(sm.getString("warResources.invalidWar", e.getMessage()));
        }
        super.setDocBase(docBase);
        this.loadEntries();
    }

    @Override
    public void release() {
        this.entries = null;
        if (this.base != null) {
            try {
                this.base.close();
            }
            catch (IOException e) {
                log.warn("Exception closing WAR File " + this.base.getName(), e);
            }
        }
        this.base = null;
        super.release();
    }

    @Override
    protected String doGetRealPath(String path) {
        return null;
    }

    @Override
    protected Object doLookup(String strName) {
        Name name;
        try {
            name = this.getEscapedJndiName(strName);
        }
        catch (InvalidNameException e) {
            log.info(sm.getString("resources.invalidName", strName), e);
            return null;
        }
        if (name.isEmpty()) {
            return this;
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            return null;
        }
        ZipEntry zipEntry = entry.getEntry();
        if (zipEntry.isDirectory()) {
            return new WARDirContext(this.base, entry);
        }
        return new WARResource(entry.getEntry());
    }

    private Name getEscapedJndiName(String name) throws InvalidNameException {
        return new CompositeName(name.replace("'", "\\'").replace("\"", ""));
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(this.getEscapedJndiName(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingContextEnumeration(this.list(this.entries).iterator());
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            throw new NameNotFoundException(sm.getString("resources.notFound", name));
        }
        return new NamingContextEnumeration(this.list(entry).iterator());
    }

    @Override
    protected List<NamingEntry> doListBindings(String strName) throws NamingException {
        Name name = this.getEscapedJndiName(strName);
        if (name.isEmpty()) {
            return this.list(this.entries);
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            return null;
        }
        return this.list(entry);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    @Override
    protected Attributes doGetAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes(this.getEscapedJndiName(name), attrIds);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        Entry entry = null;
        entry = name.isEmpty() ? this.entries : this.treeLookup(name);
        if (entry == null) {
            return null;
        }
        ZipEntry zipEntry = entry.getEntry();
        ResourceAttributes attrs = new ResourceAttributes();
        attrs.setCreationDate(new Date(zipEntry.getTime()));
        attrs.setName(entry.getName());
        if (!zipEntry.isDirectory()) {
            attrs.setResourceType("");
        } else {
            attrs.setCollection(true);
        }
        attrs.setContentLength(zipEntry.getSize());
        attrs.setLastModified(zipEntry.getTime());
        return attrs;
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected String normalize(ZipEntry entry) {
        String result = "/" + entry.getName();
        if (entry.isDirectory()) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    protected void loadEntries() {
        try {
            Enumeration<? extends ZipEntry> entryList = this.base.entries();
            this.entries = new Entry("/", new ZipEntry("/"));
            while (entryList.hasMoreElements()) {
                ZipEntry entry = entryList.nextElement();
                String name = this.normalize(entry);
                int pos = name.lastIndexOf(47);
                int currentPos = -1;
                int lastPos = 0;
                while ((currentPos = name.indexOf(47, lastPos)) != -1) {
                    Name parentName = this.getEscapedJndiName(name.substring(0, lastPos));
                    Name childName = this.getEscapedJndiName(name.substring(0, currentPos));
                    String entryName = name.substring(lastPos, currentPos);
                    Entry parent = this.treeLookup(parentName);
                    Entry child = this.treeLookup(childName);
                    if (child == null) {
                        String zipName = String.valueOf(name.substring(1, currentPos)) + "/";
                        child = new Entry(entryName, new ZipEntry(zipName));
                        if (parent != null) {
                            parent.addChild(child);
                        }
                    }
                    lastPos = currentPos + 1;
                }
                String entryName = name.substring(pos + 1, name.length());
                Name compositeName = this.getEscapedJndiName(name.substring(0, pos));
                Entry parent = this.treeLookup(compositeName);
                Entry child = new Entry(entryName, entry);
                if (parent == null) continue;
                parent.addChild(child);
            }
        }
        catch (Exception exception) {}
    }

    protected Entry treeLookup(Name name) {
        if (name.isEmpty() || this.entries == null) {
            return this.entries;
        }
        Entry currentEntry = this.entries;
        int i = 0;
        while (i < name.size()) {
            if (name.get(i).length() != 0 && (currentEntry = currentEntry.getChild(name.get(i))) == null) {
                return null;
            }
            ++i;
        }
        return currentEntry;
    }

    protected ArrayList<NamingEntry> list(Entry entry) {
        ArrayList<NamingEntry> entries = new ArrayList<NamingEntry>();
        Object[] children = entry.getChildren();
        Arrays.sort(children);
        NamingEntry namingEntry = null;
        int i = 0;
        while (i < children.length) {
            ZipEntry current = ((Entry)children[i]).getEntry();
            Object object = null;
            object = current.isDirectory() ? new WARDirContext(this.base, (Entry)children[i]) : new WARResource(current);
            namingEntry = new NamingEntry(((Entry)children[i]).getName(), object, 0);
            entries.add(namingEntry);
            ++i;
        }
        return entries;
    }

    protected static class Entry
    implements Comparable<Object> {
        protected String name = null;
        protected ZipEntry entry = null;
        protected Entry[] children = new Entry[0];

        public Entry(String name, ZipEntry entry) {
            this.name = name;
            this.entry = entry;
        }

        @Override
        public int compareTo(Object o) {
            if (!(o instanceof Entry)) {
                return 1;
            }
            return this.name.compareTo(((Entry)o).getName());
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            return this.name.equals(((Entry)o).getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public ZipEntry getEntry() {
            return this.entry;
        }

        public String getName() {
            return this.name;
        }

        public void addChild(Entry entry) {
            Entry[] newChildren = new Entry[this.children.length + 1];
            int i = 0;
            while (i < this.children.length) {
                newChildren[i] = this.children[i];
                ++i;
            }
            newChildren[this.children.length] = entry;
            this.children = newChildren;
        }

        public Entry[] getChildren() {
            return this.children;
        }

        public Entry getChild(String name) {
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i].name.equals(name)) {
                    return this.children[i];
                }
                ++i;
            }
            return null;
        }
    }

    protected class WARResource
    extends Resource {
        protected ZipEntry entry;

        public WARResource(ZipEntry entry) {
            this.entry = entry;
        }

        @Override
        public InputStream streamContent() throws IOException {
            try {
                if (this.binaryContent == null) {
                    InputStream is;
                    this.inputStream = is = WARDirContext.this.base.getInputStream(this.entry);
                    return is;
                }
            }
            catch (ZipException e) {
                throw new IOException(e.getMessage(), e);
            }
            return super.streamContent();
        }
    }
}

