/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.client;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.BrowserNavigation;
import org.eclipse.rap.rwt.client.service.BrowserNavigationEvent;
import org.eclipse.rap.rwt.client.service.BrowserNavigationListener;
import org.eclipse.rap.rwt.internal.remote.ConnectionImpl;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.SWT;

public final class BrowserNavigationImpl
implements BrowserNavigation {
    private static final String TYPE = "rwt.client.BrowserNavigation";
    private static final String PROP_NAVIGATION_LISTENER = "Navigation";
    private static final String METHOD_ADD_TO_HISTORY = "addToHistory";
    private static final String PROP_STATE = "state";
    private static final String PROP_TITLE = "title";
    private static final Object EVENT_HISTORY_NAVIGATED = "Navigation";
    private static final String EVENT_HISTORY_NAVIGATED_STATE = "state";
    private final Collection<BrowserNavigationListener> listeners;
    private final RemoteObject remoteObject;

    public BrowserNavigationImpl() {
        ConnectionImpl connection = (ConnectionImpl)RWT.getUISession().getConnection();
        this.remoteObject = connection.createServiceObject(TYPE);
        this.remoteObject.setHandler(new NavigationOperationHandler());
        this.listeners = new LinkedHashSet<BrowserNavigationListener>();
    }

    @Override
    public void pushState(String state, String title) {
        ParamCheck.notNullOrEmpty(state, "state");
        JsonObject properties = new JsonObject().add("state", state).add(PROP_TITLE, title);
        this.remoteObject.call(METHOD_ADD_TO_HISTORY, properties);
    }

    @Override
    public void addBrowserNavigationListener(BrowserNavigationListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        this.listeners.add(listener);
        if (this.listeners.size() == 1) {
            this.remoteObject.listen(PROP_NAVIGATION_LISTENER, true);
        }
    }

    @Override
    public void removeBrowserNavigationListener(BrowserNavigationListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.remoteObject.listen(PROP_NAVIGATION_LISTENER, false);
        }
    }

    void notifyListeners(BrowserNavigationEvent event) {
        BrowserNavigationListener[] listeners;
        BrowserNavigationListener[] browserNavigationListenerArray = listeners = this.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            BrowserNavigationListener listener = browserNavigationListenerArray[n2];
            listener.navigated(event);
            ++n2;
        }
    }

    private BrowserNavigationListener[] getListeners() {
        return this.listeners.toArray(new BrowserNavigationListener[this.listeners.size()]);
    }

    private final class NavigationOperationHandler
    extends AbstractOperationHandler {
        private NavigationOperationHandler() {
        }

        @Override
        public void handleNotify(String event, JsonObject properties) {
            if (EVENT_HISTORY_NAVIGATED.equals(event)) {
                String state = properties.get("state").asString();
                BrowserNavigationImpl.this.notifyListeners(new BrowserNavigationEvent(this, state));
            }
        }
    }
}

