/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemHeaders;
import org.apache.commons.fileupload2.core.FileItemHeadersImpl;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.file.PathUtils;

public interface FileItemFactory<I extends FileItem<I>> {
    public <B extends AbstractFileItemBuilder<I, B>> AbstractFileItemBuilder<I, B> fileItemBuilder();

    public static abstract class AbstractFileItemBuilder<I extends FileItem<I>, B extends AbstractFileItemBuilder<I, B>>
    extends AbstractStreamBuilder<I, B> {
        private String fieldName;
        private String contentType;
        private boolean isFormField;
        private String fileName;
        private FileItemHeaders fileItemHeaders = AbstractFileItemBuilder.newFileItemHeaders();
        private FileCleaningTracker fileCleaningTracker;

        public static FileItemHeaders newFileItemHeaders() {
            return new FileItemHeadersImpl();
        }

        public AbstractFileItemBuilder() {
            this.setBufferSize(10240);
            this.setPath(PathUtils.getTempDirectory());
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public FileCleaningTracker getFileCleaningTracker() {
            return this.fileCleaningTracker;
        }

        public FileItemHeaders getFileItemHeaders() {
            return this.fileItemHeaders;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isFormField() {
            return this.isFormField;
        }

        public B setContentType(String contentType) {
            this.contentType = contentType;
            return (B)((Object)((AbstractFileItemBuilder)this.asThis()));
        }

        public B setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return (B)((Object)((AbstractFileItemBuilder)this.asThis()));
        }

        public B setFileCleaningTracker(FileCleaningTracker fileCleaningTracker) {
            this.fileCleaningTracker = fileCleaningTracker;
            return (B)((Object)((AbstractFileItemBuilder)this.asThis()));
        }

        public B setFileItemHeaders(FileItemHeaders fileItemHeaders) {
            this.fileItemHeaders = fileItemHeaders != null ? fileItemHeaders : AbstractFileItemBuilder.newFileItemHeaders();
            return (B)((Object)((AbstractFileItemBuilder)this.asThis()));
        }

        public B setFileName(String fileName) {
            this.fileName = fileName;
            return (B)((Object)((AbstractFileItemBuilder)this.asThis()));
        }

        public B setFormField(boolean isFormField) {
            this.isFormField = isFormField;
            return (B)((Object)((AbstractFileItemBuilder)this.asThis()));
        }
    }
}

