/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetDataUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.scripting.ClientListenerUtil;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.scripting.ClientListener;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.WidgetRemoteAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DropDown
extends Widget {
    private static final String COLUMNS = "columns";
    private static final String REMOTE_TYPE = "rwt.widgets.DropDown";
    private static final String SELECTION = "Selection";
    private static final String DEFAULT_SELECTION = "DefaultSelection";
    private static final String[] ALLOWED_STYLES = new String[]{"V_SCROLL", "H_SCROLL"};
    private final List<String> items;
    private RemoteObject remoteObject;
    private Object widgetAdapter;
    private final Control parent;
    private final Listener disposeListener;
    private boolean visibility = false;
    private int selectionIndex = -1;
    private int visibleItemCount = 5;

    public DropDown(Control parent, int style) {
        super(parent, DropDown.checkStyle(style));
        this.parent = parent;
        this.items = new ArrayList<String>();
        this.getRemoteObject().set("parent", WidgetUtil.getId(parent));
        this.getRemoteObject().set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(this, ALLOWED_STYLES)));
        this.getRemoteObject().setHandler(new InternalOperationHandler());
        this.disposeListener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                DropDown.this.dispose();
            }
        };
        parent.addListener(12, this.disposeListener);
    }

    public DropDown(Control parent) {
        this(parent, 512);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                SWT.error(5);
            }
            ++i;
        }
        this.items.clear();
        this.items.addAll(Arrays.asList(items));
        this.remoteObject.set("items", JsonUtil.createJsonArray(items));
        this.setSelectionIndexImpl(-1);
    }

    public String[] getItems() {
        this.checkWidget();
        return this.items.toArray(new String[this.items.size()]);
    }

    public void setSelectionIndex(int selection) {
        this.checkWidget();
        if (this.selectionIndex != selection && selection >= -1 && selection < this.items.size()) {
            this.setSelectionIndexImpl(selection);
            this.remoteObject.set("selectionIndex", selection);
        }
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.selectionIndex;
    }

    public void setVisibleItemCount(int itemCount) {
        this.checkWidget();
        if (this.visibleItemCount != itemCount) {
            this.visibleItemCount = itemCount;
            this.remoteObject.set("visibleItemCount", itemCount);
        }
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleItemCount;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.visibility != visible) {
            this.setVisibleImpl(visible);
            this.remoteObject.set("visible", visible);
        }
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visibility;
    }

    public Control getParent() {
        this.checkWidget();
        return this.parent;
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            super.dispose();
            this.parent.removeListener(12, this.disposeListener);
            this.remoteObject.destroy();
        }
    }

    @Override
    public void setData(String key, Object value) {
        super.setData(key, value);
        this.renderData(key, value);
        if ("org.eclipse.rap.rwt.markupEnabled".equals(key) && value instanceof Boolean) {
            this.remoteObject.set("markupEnabled", (Boolean)value);
        } else if (COLUMNS.equals(key)) {
            if (value instanceof int[]) {
                int[] arr = (int[])value;
                this.remoteObject.set(COLUMNS, JsonUtil.createJsonArray(arr));
            } else {
                this.remoteObject.set(COLUMNS, JsonValue.NULL);
            }
        }
    }

    @Override
    public void addListener(int eventType, Listener listener) {
        boolean wasListening = EventLCAUtil.isListening(this, eventType);
        super.addListener(eventType, listener);
        boolean isListening = EventLCAUtil.isListening(this, eventType);
        String remoteType = DropDown.eventTypeToString(eventType);
        if (listener instanceof ClientListener) {
            JsonObject parameters = new JsonObject().add("eventType", ClientListenerUtil.getEventType(eventType)).add("listenerId", ClientListenerUtil.getRemoteId((ClientListener)listener));
            this.remoteObject.call("addListener", parameters);
        } else if (remoteType != null && !wasListening && isListening) {
            this.remoteObject.listen(remoteType, true);
        }
    }

    @Override
    public void removeListener(int eventType, Listener listener) {
        boolean wasListening = EventLCAUtil.isListening(this, eventType);
        super.removeListener(eventType, listener);
        boolean isListening = EventLCAUtil.isListening(this, eventType);
        String remoteType = DropDown.eventTypeToString(eventType);
        if (listener instanceof ClientListener) {
            JsonObject parameters = new JsonObject().add("eventType", ClientListenerUtil.getEventType(eventType)).add("listenerId", ClientListenerUtil.getRemoteId((ClientListener)listener));
            this.remoteObject.call("removeListener", parameters);
        } else if (remoteType != null && wasListening && !isListening) {
            this.remoteObject.listen(remoteType, false);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == RemoteAdapter.class) {
            if (this.widgetAdapter == null) {
                this.widgetAdapter = new WidgetRemoteAdapter(this.getProtocolId());
            }
            result = this.widgetAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    private void setVisibleImpl(boolean value) {
        this.visibility = value;
    }

    private void setSelectionIndexImpl(int value) {
        this.selectionIndex = value;
    }

    private String getProtocolId() {
        return this.getRemoteObject().getId();
    }

    private RemoteObject getRemoteObject() {
        if (this.remoteObject == null) {
            this.remoteObject = RWT.getUISession().getConnection().createRemoteObject(REMOTE_TYPE);
        }
        return this.remoteObject;
    }

    private void renderData(String key, Object value) {
        if (WidgetDataUtil.getDataKeys().contains(key)) {
            JsonObject data = new JsonObject().add(key, JsonUtil.createJsonValue(value));
            this.remoteObject.set("data", data);
        }
    }

    private static String eventTypeToString(int type) {
        String result;
        switch (type) {
            case 13: {
                result = SELECTION;
                break;
            }
            case 14: {
                result = DEFAULT_SELECTION;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private static int stringToEventType(String str) {
        int result = -1;
        if (SELECTION.equals(str)) {
            result = 13;
        } else if (DEFAULT_SELECTION.equals(str)) {
            result = 14;
        }
        return result;
    }

    private static int checkStyle(int style) {
        return style | 0x200;
    }

    private class InternalOperationHandler
    extends AbstractOperationHandler {
        private InternalOperationHandler() {
        }

        @Override
        public void handleSet(JsonObject properties) {
            if (properties.get("visible") != null) {
                DropDown.this.setVisibleImpl(properties.get("visible").asBoolean());
            }
            if (properties.get("selectionIndex") != null) {
                DropDown.this.setSelectionIndexImpl(properties.get("selectionIndex").asInt());
            }
        }

        @Override
        public void handleNotify(String type, JsonObject properties) {
            if (DropDown.SELECTION.equals(type) || DropDown.DEFAULT_SELECTION.equals(type)) {
                Event event = new Event();
                event.index = properties.get("index").asInt();
                event.text = properties.get("text").asString();
                DropDown.this.notifyListeners(DropDown.stringToEventType(type), event);
            }
        }
    }
}

