/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.widgets.fileuploadkit;

import java.io.IOException;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.widgets.IFileUploadAdapter;
import org.eclipse.rap.rwt.internal.widgets.fileuploadkit.FileUploadOperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.widgets.FileUpload;
import org.eclipse.swt.widgets.Widget;

public final class FileUploadLCA
extends WidgetLCA<FileUpload> {
    public static final FileUploadLCA INSTANCE = new FileUploadLCA();
    private static final String TYPE = "rwt.widgets.FileUpload";
    private static final String[] ALLOWED_STYLES = new String[]{"BORDER", "MULTI"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_FILTER_EXTENSIONS = "filterExtensions";
    private static final String[] DEFAUT_FILTER_EXTENSIONS = new String[0];

    @Override
    public void preserveValues(FileUpload fileUpload) {
        WidgetLCAUtil.preserveProperty((Widget)fileUpload, PROP_TEXT, fileUpload.getText());
        WidgetLCAUtil.preserveProperty((Widget)fileUpload, PROP_IMAGE, fileUpload.getImage());
        WidgetLCAUtil.preserveProperty((Widget)fileUpload, PROP_FILTER_EXTENSIONS, fileUpload.getFilterExtensions());
    }

    @Override
    public void renderInitialization(FileUpload fileUpload) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(fileUpload, TYPE);
        remoteObject.setHandler(new FileUploadOperationHandler(fileUpload));
        remoteObject.set("parent", WidgetUtil.getId(fileUpload.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(fileUpload, ALLOWED_STYLES)));
    }

    @Override
    public void renderChanges(FileUpload fileUpload) throws IOException {
        ControlLCAUtil.renderChanges(fileUpload);
        WidgetLCAUtil.renderCustomVariant(fileUpload);
        WidgetLCAUtil.renderProperty((Widget)fileUpload, PROP_TEXT, fileUpload.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)fileUpload, PROP_IMAGE, fileUpload.getImage(), null);
        WidgetLCAUtil.renderProperty((Widget)fileUpload, PROP_FILTER_EXTENSIONS, fileUpload.getFilterExtensions(), DEFAUT_FILTER_EXTENSIONS);
        WidgetLCAUtil.renderListenSelection(fileUpload);
        FileUploadLCA.renderSubmit(fileUpload);
    }

    private static void renderSubmit(FileUpload fileUpload) {
        String url = fileUpload.getAdapter(IFileUploadAdapter.class).getAndResetUrl();
        if (url != null) {
            RemoteObjectFactory.getRemoteObject(fileUpload).call("submit", new JsonObject().add("url", url));
        }
    }

    private FileUploadLCA() {
    }
}

