/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ShellTab
extends ExampleTab {
    private static final String ICON_IMAGE_PATH = "resources/newfile_wiz.gif";
    private final List<Shell> shells = new ArrayList<Shell>();
    private int shellCounter;
    private final ShellAdapter confirmCloseListener = new ShellAdapter(){

        public void shellClosed(ShellEvent event) {
            boolean canClose;
            Shell shell = (Shell)event.widget;
            String msg = "Close " + shell.getText() + "?";
            event.doit = canClose = MessageDialog.openConfirm((Shell)shell, (String)"Confirm", (String)msg);
        }
    };
    private Image shellImage;
    private Button createRTLButton;
    private Button createInvisibleButton;
    private Button createAsDialogButton;
    private Button createWithMenuButton;
    private Button showClientAreaButton;
    private Button confirmCloseButton;
    private int alpha = 255;

    public ShellTab() {
        super("Shell");
        this.setDefaultStyle(1264);
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("SHELL_TRIM", 1264, true);
        this.createStyleButton("DIALOG_TRIM", 2144);
        this.createStyleButton("APPLICATION_MODAL", 65536);
        this.createStyleButton("PRIMARY_MODAL", 32768);
        this.createStyleButton("TITLE", 32);
        this.createStyleButton("MIN", 128);
        this.createStyleButton("MAX", 1024);
        this.createStyleButton("CLOSE", 64);
        this.createStyleButton("RESIZE", 16);
        this.createStyleButton("TOOL", 4);
        this.createStyleButton("SHEET", 0x10000000);
        this.createStyleButton("ON_TOP", 16384);
        this.createRTLButton = this.createOrientationButton();
        this.createInvisibleButton = this.createPropertyButton("Create invisible");
        this.createAsDialogButton = this.createPropertyButton("Create as dialog");
        this.createWithMenuButton = this.createPropertyButton("Add menu");
        this.showClientAreaButton = this.createPropertyButton("Show client area");
        this.confirmCloseButton = this.createPropertyButton("Confirm Close");
        this.createAlphaControls(parent);
    }

    @Override
    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        if (this.shellImage == null) {
            this.shellImage = Util.loadImage(parent.getDisplay(), ICON_IMAGE_PATH);
        }
        Button openShellButton = new Button(parent, 8);
        openShellButton.setText("Open Shell");
        openShellButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ShellTab.this.createShell();
            }
        });
        Button bringFirstToTopButton = new Button(parent, 8);
        bringFirstToTopButton.setText("Bring first Shell to top");
        bringFirstToTopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Shell[] shells = ShellTab.this.getShells();
                if (shells.length > 0) {
                    shells[0].open();
                }
            }
        });
        Button showAllButton = new Button(parent, 8);
        showAllButton.setText("Show All Shells");
        showAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ShellTab.this.setShellsVisible(true);
            }
        });
        Button hideAllButton = new Button(parent, 8);
        hideAllButton.setText("Hide All Shells");
        hideAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ShellTab.this.setShellsVisible(false);
            }
        });
        Button MaximizeAllButton = new Button(parent, 8);
        MaximizeAllButton.setText("Maximize All Shells");
        MaximizeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ShellTab.this.setShellsMaximized(true);
            }
        });
        Button minimizeAllButton = new Button(parent, 8);
        minimizeAllButton.setText("Minimize All Shells");
        minimizeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ShellTab.this.setShellsMinimized(true);
            }
        });
        Button restoreAllButton = new Button(parent, 8);
        restoreAllButton.setText("Restore All Shells");
        restoreAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ShellTab.this.setShellsMinimized(false);
                ShellTab.this.setShellsMaximized(false);
            }
        });
        Button enableAllButton = new Button(parent, 8);
        enableAllButton.setText("Enable All Shells");
        enableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ShellTab.this.setShellsEnabled(true);
            }
        });
        Button disableAllButton = new Button(parent, 8);
        disableAllButton.setText("Disable All Shells");
        disableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ShellTab.this.setShellsEnabled(false);
            }
        });
        Button closeAllButton = new Button(parent, 8);
        closeAllButton.setText("Close All Shells");
        closeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ShellTab.this.closeShells();
            }
        });
    }

    private void createAlphaControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(comp, 0);
        label.setText("Alpha");
        final Text text = new Text(comp, 2048);
        text.setText("255");
        Button button = new Button(comp, 8);
        button.setText("set");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    ShellTab.this.alpha = Integer.parseInt(text.getText());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
    }

    private void createShell() {
        Shell shell = this.createAsDialogButton.getSelection() ? new Shell(this.getShell(), this.getStyle()) : new Shell(this.getShell().getDisplay(), this.getStyle());
        if (this.createRTLButton.getSelection()) {
            shell.setOrientation(0x4000000);
        }
        shell.setLocation(this.getNextShellLocation());
        this.createShellContents(shell);
        ++this.shellCounter;
        shell.setText("Test Shell " + this.shellCounter);
        shell.setAlpha(this.alpha);
        shell.setImage(this.shellImage);
        if (this.confirmCloseButton.getSelection()) {
            shell.addShellListener((ShellListener)this.confirmCloseListener);
        }
        if (!this.createInvisibleButton.getSelection()) {
            shell.open();
        }
        this.shells.add(shell);
    }

    private void createShellContents(final Shell shell) {
        shell.setSize(300, 200);
        if (this.createWithMenuButton.getSelection()) {
            this.createMenuBar(shell);
        }
        final Composite comp1 = new Composite((Composite)shell, 0);
        final Composite comp2 = new Composite((Composite)shell, 0);
        comp2.moveAbove((Control)comp1);
        if (this.showClientAreaButton.getSelection()) {
            comp1.setBackground(new Color((Device)shell.getDisplay(), 200, 0, 0));
            comp2.setBackground(new Color((Device)shell.getDisplay(), 200, 200, 200));
        }
        Rectangle area = shell.getClientArea();
        comp1.setBounds(area.x, area.y, area.width, area.height);
        comp2.setBounds(area.x + 1, area.y + 1, area.width - 2, area.height - 2);
        final Button closeButton = new Button(comp2, 8);
        closeButton.setText("Close This Shell");
        closeButton.pack();
        int centerX = (area.width - area.x) / 2;
        closeButton.setLocation(centerX - closeButton.getSize().x / 2, area.height - 45);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                Rectangle area = shell.getClientArea();
                comp1.setBounds(area.x, area.y, area.width, area.height);
                comp2.setBounds(area.x + 1, area.y + 1, area.width - 2, area.height - 2);
                int centerX = (area.width - area.x) / 2;
                closeButton.setLocation(centerX - closeButton.getSize().x / 2, area.height - 45);
            }
        });
    }

    private void createMenuBar(Shell shell) {
        Menu menuBar = new Menu((Decorations)shell, 2);
        shell.setMenuBar(menuBar);
        MenuItem fileItem = new MenuItem(menuBar, 64);
        fileItem.setText("File");
        MenuItem editItem = new MenuItem(menuBar, 64);
        editItem.setText("Edit");
        MenuItem searchItem = new MenuItem(menuBar, 64);
        searchItem.setText("Search");
        MenuItem disabledItem = new MenuItem(menuBar, 64);
        disabledItem.setText("Disabled");
        disabledItem.setEnabled(false);
        new MenuItem(menuBar, 64).setText("Item 6");
        new MenuItem(menuBar, 64).setText("Item 7");
        new MenuItem(menuBar, 64).setText("Item 8");
        new MenuItem(menuBar, 64).setText("Item 9");
        Menu fileMenu = new Menu((Decorations)shell, 4);
        fileItem.setMenu(fileMenu);
        MenuItem newItem = new MenuItem(fileMenu, 8);
        newItem.setText("&New\tStrg+FOO");
        newItem.setImage(Util.loadImage(shell.getDisplay(), ICON_IMAGE_PATH));
        new MenuItem(fileMenu, 8).setText("Open");
        new MenuItem(fileMenu, 8).setText("Close");
        Menu editMenu = new Menu((Decorations)shell, 4);
        editItem.setMenu(editMenu);
        new MenuItem(editMenu, 8).setText("Copy");
        new MenuItem(editMenu, 8).setText("Paste");
        new MenuItem(editMenu, 2);
        MenuItem item = new MenuItem(editMenu, 64);
        item.setText("Insert");
        Menu cascadeMenu = new Menu((Decorations)shell, 4);
        item.setMenu(cascadeMenu);
        new MenuItem(cascadeMenu, 8).setText("Date");
        new MenuItem(cascadeMenu, 8).setText("Line Break");
        Menu searchMenu = new Menu((Decorations)shell, 4);
        searchItem.setMenu(searchMenu);
        new MenuItem(searchMenu, 8).setText("Enabled");
        item = new MenuItem(searchMenu, 8);
        item.setText("Disabled");
        item.setEnabled(false);
        item = new MenuItem(searchMenu, 8);
        item.setText("Push\tCtrl+Shift+P");
        item.setAccelerator(SWT.MOD1 + SWT.MOD2 + 80);
        new MenuItem(searchMenu, 2);
        item = new MenuItem(searchMenu, 32);
        item.setText("Check\tCtrl+Shift+C");
        item.setAccelerator(SWT.MOD1 + SWT.MOD2 + 67);
        item = new MenuItem(searchMenu, 16);
        item.setText("Radio 1\tCtrl+Shift+1");
        item.setAccelerator(SWT.MOD1 + SWT.MOD2 + 49);
        item = new MenuItem(searchMenu, 16);
        item.setText("Radio 2\tCtrl+Shift+2");
        item.setAccelerator(SWT.MOD1 + SWT.MOD2 + 50);
        item = new MenuItem(searchMenu, 16);
        item.setText("Radio 3\tCtrl+Shift+3");
        item.setAccelerator(SWT.MOD1 + SWT.MOD2 + 51);
        item.setEnabled(false);
        Menu disabledMenu = new Menu((Decorations)shell, 4);
        disabledMenu.setEnabled(false);
        disabledItem.setMenu(disabledMenu);
        new MenuItem(disabledMenu, 8).setText("Import");
        new MenuItem(disabledMenu, 8).setText("Export");
    }

    private Point getNextShellLocation() {
        Point result = this.getShell().getLocation();
        int count = this.getShells().length % 12;
        result.x += 50 + count * 10;
        result.y += 50 + count * 10;
        return result;
    }

    private void closeShells() {
        Shell[] shells2 = this.getShells();
        int i = 0;
        while (i < shells2.length) {
            shells2[i].removeShellListener((ShellListener)this.confirmCloseListener);
            shells2[i].close();
            shells2[i].dispose();
            ++i;
        }
    }

    private void setShellsVisible(boolean visible) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setVisible(visible);
            ++i;
        }
    }

    private void setShellsEnabled(boolean enabled) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setEnabled(enabled);
            ++i;
        }
    }

    private void setShellsMinimized(boolean minimized) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setMinimized(minimized);
            ++i;
        }
    }

    private void setShellsMaximized(boolean maximized) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setMaximized(maximized);
            ++i;
        }
    }

    private Shell[] getShells() {
        Iterator<Shell> iter = this.shells.iterator();
        while (iter.hasNext()) {
            Shell shell = iter.next();
            if (!shell.isDisposed()) continue;
            iter.remove();
        }
        Shell[] result = new Shell[this.shells.size()];
        this.shells.toArray(result);
        return result;
    }
}

