/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.widgets.Display;

final class TimerExecScheduler {
    private final Display display;
    private List tasks;
    private Timer scheduler;

    public TimerExecScheduler(Display display) {
        this.display = display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(int milliseconds, Runnable runnable) {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            this.initialize();
            TimerExecTask task = new TimerExecTask(runnable);
            this.tasks.add(task);
            this.scheduler.schedule((TimerTask)task, milliseconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(Runnable runnable) {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            if (this.tasks != null) {
                Iterator iter = this.tasks.iterator();
                boolean found = false;
                while (!found && iter.hasNext()) {
                    TimerExecTask task = (TimerExecTask)iter.next();
                    if (task.getRunnable() != runnable) continue;
                    this.removeTask(task);
                    task.cancel();
                    found = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            if (this.scheduler != null) {
                this.scheduler.cancel();
            }
            if (this.tasks != null) {
                this.tasks.clear();
            }
        }
    }

    private void initialize() {
        if (this.scheduler == null) {
            this.scheduler = new Timer(true);
        }
        if (this.tasks == null) {
            this.tasks = new LinkedList();
        }
    }

    private void removeTask(TimerTask task) {
        this.tasks.remove(task);
    }

    private final class TimerExecTask
    extends TimerTask {
        private final Runnable runnable;

        private TimerExecTask(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = TimerExecScheduler.this.display.getDeviceLock();
            synchronized (object) {
                if (!TimerExecScheduler.this.display.isDisposed()) {
                    TimerExecScheduler.this.removeTask(this);
                    TimerExecScheduler.this.display.asyncExec(this.runnable);
                }
            }
        }

        Runnable getRunnable() {
            return this.runnable;
        }
    }
}

