/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaFieldImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaMethodImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaPackageImpl;

public class JavaClassImpl
implements JavaClass {
    protected ParameterizedType jType;
    protected Class jClass;

    public JavaClassImpl(Class javaClass) {
        this.jClass = javaClass;
    }

    public JavaClassImpl(ParameterizedType javaType, Class javaClass) {
        this.jType = javaType;
        this.jClass = javaClass;
    }

    public Collection getActualTypeArguments() {
        ArrayList<JavaClassImpl> argCollection = new ArrayList<JavaClassImpl>();
        if (this.jType instanceof ParameterizedType) {
            Type[] params;
            ParameterizedType pType = this.jType;
            for (Type type : params = pType.getActualTypeArguments()) {
                if (type instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)type;
                    argCollection.add(new JavaClassImpl(pt, (Class)pt.getRawType()));
                    continue;
                }
                if (type instanceof Class) {
                    argCollection.add(new JavaClassImpl((Class)type));
                    continue;
                }
                if (!(type instanceof GenericArrayType)) continue;
                Class<?> genericTypeClass = (Class<?>)((GenericArrayType)type).getGenericComponentType();
                genericTypeClass = Array.newInstance(genericTypeClass, 0).getClass();
                argCollection.add(new JavaClassImpl(genericTypeClass));
            }
        }
        return argCollection;
    }

    public String toString() {
        return this.getName();
    }

    public JavaAnnotation getAnnotation(JavaClass arg0) {
        Class annotationClass;
        if (arg0 != null && this.jClass.isAnnotationPresent(annotationClass = ((JavaClassImpl)arg0).getJavaClass())) {
            return new JavaAnnotationImpl((Annotation)this.jClass.getAnnotation(annotationClass));
        }
        return null;
    }

    public Collection getAnnotations() {
        Annotation[] annotations;
        ArrayList<JavaAnnotationImpl> annotationCollection = new ArrayList<JavaAnnotationImpl>();
        for (Annotation annotation : annotations = this.jClass.getAnnotations()) {
            annotationCollection.add(new JavaAnnotationImpl(annotation));
        }
        return annotationCollection;
    }

    public Collection getDeclaredClasses() {
        Class<?>[] classes;
        ArrayList<JavaClassImpl> classCollection = new ArrayList<JavaClassImpl>();
        for (Class<?> javaClass : classes = this.jClass.getDeclaredClasses()) {
            classCollection.add(new JavaClassImpl(javaClass));
        }
        return classCollection;
    }

    public JavaField getDeclaredField(String arg0) {
        try {
            return new JavaFieldImpl(this.jClass.getDeclaredField(arg0));
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
    }

    public Collection getDeclaredFields() {
        Field[] fields;
        ArrayList<JavaFieldImpl> fieldCollection = new ArrayList<JavaFieldImpl>();
        for (Field field : fields = this.jClass.getDeclaredFields()) {
            fieldCollection.add(new JavaFieldImpl(field));
        }
        return fieldCollection;
    }

    public JavaMethod getDeclaredMethod(String arg0, JavaClass[] arg1) {
        if (arg1 == null) {
            arg1 = new JavaClass[]{};
        }
        Class[] params = new Class[arg1.length];
        for (int i = 0; i < arg1.length; ++i) {
            JavaClass jType = arg1[i];
            if (jType == null) continue;
            params[i] = ((JavaClassImpl)jType).getJavaClass();
        }
        try {
            return new JavaMethodImpl(this.jClass.getDeclaredMethod(arg0, params));
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    public Collection getDeclaredMethods() {
        Method[] methods;
        ArrayList<JavaMethodImpl> methodCollection = new ArrayList<JavaMethodImpl>();
        for (Method method : methods = this.jClass.getDeclaredMethods()) {
            methodCollection.add(new JavaMethodImpl(method));
        }
        return methodCollection;
    }

    public JavaField getField(String arg0) {
        try {
            return new JavaFieldImpl(this.jClass.getField(arg0));
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
    }

    public Collection getFields() {
        Field[] fields;
        ArrayList<JavaFieldImpl> fieldCollection = new ArrayList<JavaFieldImpl>();
        for (Field field : fields = this.jClass.getFields()) {
            fieldCollection.add(new JavaFieldImpl(field));
        }
        return fieldCollection;
    }

    public Class getJavaClass() {
        return this.jClass;
    }

    public JavaMethod getMethod(String arg0, JavaClass[] arg1) {
        if (arg1 == null) {
            arg1 = new JavaClass[]{};
        }
        Class[] params = new Class[arg1.length];
        for (int i = 0; i < arg1.length; ++i) {
            JavaClass jType = arg1[i];
            if (jType == null) continue;
            params[i] = ((JavaClassImpl)jType).getJavaClass();
        }
        try {
            return new JavaMethodImpl(this.jClass.getMethod(arg0, params));
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    public Collection getMethods() {
        Method[] methods;
        ArrayList<JavaMethodImpl> methodCollection = new ArrayList<JavaMethodImpl>();
        for (Method method : methods = this.jClass.getMethods()) {
            methodCollection.add(new JavaMethodImpl(method));
        }
        return methodCollection;
    }

    public String getName() {
        return this.jClass.getName();
    }

    public JavaPackage getPackage() {
        return new JavaPackageImpl(this.jClass.getPackage());
    }

    public String getPackageName() {
        return this.jClass.getPackage().getName();
    }

    public String getQualifiedName() {
        return this.jClass.getName();
    }

    public String getRawName() {
        return this.jClass.getCanonicalName();
    }

    public JavaClass getSuperclass() {
        return new JavaClassImpl(this.jClass.getSuperclass());
    }

    public boolean hasActualTypeArguments() {
        ParameterizedType pType;
        return this.jType instanceof ParameterizedType && (pType = this.jType).getActualTypeArguments() != null && pType.getActualTypeArguments().length > 0;
    }

    public JavaClass getOwningClass() {
        return new JavaClassImpl(this.jClass.getEnclosingClass());
    }

    public boolean isAnnotation() {
        return this.jClass.isAnnotation();
    }

    public boolean isArray() {
        return this.jClass.isArray();
    }

    public boolean isAssignableFrom(JavaClass arg0) {
        return this.jClass.isAssignableFrom(((JavaClassImpl)arg0).getJavaClass());
    }

    public boolean isEnum() {
        return this.jClass.isEnum();
    }

    public boolean isInterface() {
        return this.jClass.isInterface();
    }

    public boolean isMemberClass() {
        return this.jClass.isMemberClass();
    }

    public boolean isPrimitive() {
        return this.jClass.isPrimitive();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public int getModifiers() {
        return this.jClass.getModifiers();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isSynthetic() {
        return this.jClass.isSynthetic();
    }

    public JavaClass getComponentType() {
        return null;
    }

    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        return null;
    }

    public Collection getDeclaredAnnotations() {
        return null;
    }
}

