/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dbws;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.eclipse.persistence.dbws.DBWSModelProject;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.dbws.DBWSAdapter;
import org.eclipse.persistence.internal.dbws.SOAPResponseWriter;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.xr.Invocation;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.ValueObject;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.internal.xr.XRServiceFactory;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.sessions.Project;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProviderHelper
extends XRServiceFactory {
    public static final String SERVICE_NS_PREFIX = "srvc";
    protected static final String XSL_PREAMBLE = "<?xml version=\"1.0\"?> <xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" > <xsl:output method=\"xml\" encoding=\"UTF-8\"/> ";
    protected static final String XSL_POSTSCRIPT = "</xsl:stylesheet>";
    protected static final String MATCH_SCHEMA = "<?xml version=\"1.0\"?> <xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" > <xsl:output method=\"xml\" encoding=\"UTF-8\"/> <xsl:template match=\"/\"><xsl:apply-templates/></xsl:template><xsl:template match=\"//xsd:schema\"><xsl:copy-of select=\".\"/></xsl:template></xsl:stylesheet>";
    protected SOAPResponseWriter responseWriter = null;

    public void init(ClassLoader parentClassLoader, ServletContext sc) {
        XRServiceModel xrServiceModel;
        String searchPath;
        String path;
        this.parentClassLoader = parentClassLoader;
        InputStream xrServiceStream = null;
        String[] arr$ = Util.META_INF_PATHS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (xrServiceStream = parentClassLoader.getResourceAsStream(path = (searchPath = arr$[i$]) + "eclipselink-dbws.xml")) == null; ++i$) {
        }
        if (xrServiceStream == null) {
            throw new WebServiceException((Throwable)DBWSException.couldNotLocateFile("eclipselink-dbws.xml"));
        }
        DBWSModelProject xrServiceModelProject = new DBWSModelProject();
        XMLContext xmlContext = new XMLContext(xrServiceModelProject);
        XMLUnmarshaller unmarshaller = xmlContext.createUnmarshaller();
        try {
            xrServiceModel = (XRServiceModel)unmarshaller.unmarshal(xrServiceStream);
        }
        catch (XMLMarshalException e) {
            throw new WebServiceException((Throwable)DBWSException.couldNotParseDBWSFile());
        }
        try {
            xrServiceStream.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        path = "wsdl/eclipselink-dbws-schema.xsd";
        if (sc != null) {
            path = "WEB-INF/" + path;
            this.xrSchemaStream = sc.getResourceAsStream(path);
        } else {
            this.xrSchemaStream = parentClassLoader.getResourceAsStream(path);
        }
        if (this.xrSchemaStream == null) {
            throw new WebServiceException((Throwable)DBWSException.couldNotLocateFile("eclipselink-dbws-schema.xsd"));
        }
        try {
            this.buildService(xrServiceModel);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        DBWSAdapter dbwsAdapter = (DBWSAdapter)this.xrService;
        StringWriter sw = new StringWriter();
        InputStream wsdlInputStream = null;
        path = "wsdl/eclipselink-dbws.wsdl";
        if (sc != null) {
            path = "WEB-INF/" + path;
            wsdlInputStream = sc.getResourceAsStream(path);
        } else {
            wsdlInputStream = parentClassLoader.getResourceAsStream(path);
        }
        if (wsdlInputStream == null) {
            throw new WebServiceException((Throwable)DBWSException.couldNotLocateFile("eclipselink-dbws.wsdl"));
        }
        try {
            StreamSource wsdlStreamSource = new StreamSource(wsdlInputStream);
            Transformer t = ProviderHelper.getTransformerFactory().newTransformer(new StreamSource(new StringReader(MATCH_SCHEMA)));
            StreamResult streamResult = new StreamResult(sw);
            t.transform(wsdlStreamSource, streamResult);
            sw.toString();
            wsdlInputStream.close();
            SchemaModelProject schemaProject = new SchemaModelProject();
            XMLContext xmlContext2 = new XMLContext(schemaProject);
            unmarshaller = xmlContext2.createUnmarshaller();
            Schema extendedSchema = (Schema)unmarshaller.unmarshal(new StringReader(sw.toString()));
            dbwsAdapter.setExtendedSchema(extendedSchema);
        }
        catch (Exception e) {
            // empty catch block
        }
        Project oxProject = dbwsAdapter.getOXSession().getProject();
        for (XMLDescriptor d : oxProject.getDescriptors().values()) {
            String defaultRootElement;
            NamespaceResolver ns = d.getNamespaceResolver();
            String tns = dbwsAdapter.getExtendedSchema().getTargetNamespace();
            if (ns != null) {
                ns.put(SERVICE_NS_PREFIX, tns);
            }
            if ((defaultRootElement = d.getDefaultRootElement()) == null) continue;
            int idx = defaultRootElement.indexOf(58);
            if (idx > 0) {
                defaultRootElement = defaultRootElement.substring(idx + 1);
            }
            d.addRootElement("srvc:" + defaultRootElement);
        }
        XMLDescriptor invocationDescriptor = new XMLDescriptor();
        invocationDescriptor.setJavaClass(Invocation.class);
        NamespaceResolver ns = new NamespaceResolver();
        invocationDescriptor.setNamespaceResolver(ns);
        ns.put(SERVICE_NS_PREFIX, dbwsAdapter.getExtendedSchema().getTargetNamespace());
        XMLAnyCollectionMapping parametersMapping = new XMLAnyCollectionMapping();
        parametersMapping.setAttributeName("parameters");
        parametersMapping.setAttributeAccessor(new AttributeAccessor(){
            Project oxProject;

            public Object getAttributeValueFromObject(Object object) {
                return ((Invocation)object).getParameters();
            }

            public void setAttributeValueInObject(Object object, Object value) {
                Invocation invocation = (Invocation)object;
                Vector values = (Vector)value;
                block4: for (Object o : values) {
                    String key;
                    if (o instanceof Element) {
                        Element e = (Element)o;
                        key = e.getLocalName();
                        if ("theInstance".equals(key)) {
                            NodeList nl = e.getChildNodes();
                            for (int j = 0; j < nl.getLength(); ++j) {
                                Node n = nl.item(j);
                                if (n.getNodeType() != 1) continue;
                                try {
                                    Object theInstance = new XMLContext(this.oxProject).createUnmarshaller().unmarshal(n);
                                    if (theInstance instanceof XMLRoot) {
                                        theInstance = ((XMLRoot)theInstance).getObject();
                                    }
                                    invocation.setParameter(key, theInstance);
                                    continue block4;
                                }
                                catch (XMLMarshalException xmlMarshallException) {
                                    throw new WebServiceException((Throwable)xmlMarshallException);
                                }
                            }
                            continue;
                        }
                        String lname = e.getLocalName();
                        if (this.oxProject.getDescriptorForAlias(lname) != null) {
                            Element n = e;
                            try {
                                Object theObject = new XMLContext(this.oxProject).createUnmarshaller().unmarshal(n);
                                if (theObject instanceof XMLRoot) {
                                    theObject = ((XMLRoot)theObject).getObject();
                                }
                                invocation.setParameter(key, theObject);
                                continue;
                            }
                            catch (XMLMarshalException xmlMarshallException) {
                                throw new WebServiceException((Throwable)xmlMarshallException);
                            }
                        }
                        String val = e.getTextContent();
                        invocation.setParameter(key, val);
                        continue;
                    }
                    XMLDescriptor descriptor = (XMLDescriptor)this.oxProject.getDescriptor(o.getClass());
                    key = descriptor.getDefaultRootElement();
                    int idx = key.indexOf(58);
                    if (idx != -1) {
                        key = key.substring(idx + 1);
                    }
                    invocation.setParameter(key, o);
                }
            }

            public AttributeAccessor setProject(Project oxProject) {
                this.oxProject = oxProject;
                return this;
            }
        }.setProject(oxProject));
        parametersMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        invocationDescriptor.addMapping(parametersMapping);
        oxProject.addDescriptor(invocationDescriptor);
        ((DatabaseSessionImpl)dbwsAdapter.getOXSession()).initializeDescriptorIfSessionAlive(invocationDescriptor);
        dbwsAdapter.getXMLContext().storeXMLDescriptorByQName(invocationDescriptor);
        this.responseWriter = new SOAPResponseWriter(dbwsAdapter);
        this.responseWriter.initialize();
    }

    public SOAPMessage invoke(SOAPMessage request) {
        ComplexType complexType;
        SOAPElement body;
        SOAPMessage response = null;
        DBWSAdapter dbwsAdapter = (DBWSAdapter)this.xrService;
        try {
            body = ProviderHelper.getSOAPBodyElement(request);
        }
        catch (SOAPException se) {
            throw new WebServiceException(se.getMessage());
        }
        if (body == null) {
            SOAPFault soapFault = null;
            try {
                soapFault = ProviderHelper.getSOAPFactory().createFault("SOAPMessage request format error - missing body element", new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client"));
            }
            catch (SOAPException se) {
                // empty catch block
            }
            throw new SOAPFaultException(soapFault);
        }
        XMLRoot xmlRoot = null;
        try {
            XMLContext xmlContext = dbwsAdapter.getXMLContext();
            xmlRoot = (XMLRoot)xmlContext.createUnmarshaller().unmarshal((Node)body, Invocation.class);
        }
        catch (XMLMarshalException e) {
            SOAPFault soapFault = null;
            try {
                soapFault = ProviderHelper.getSOAPFactory().createFault("SOAPMessage request format error - " + e.getMessage(), new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client"));
            }
            catch (SOAPException se) {
                // empty catch block
            }
            throw new SOAPFaultException(soapFault);
        }
        Invocation invocation = (Invocation)xmlRoot.getObject();
        invocation.setName(xmlRoot.getLocalName());
        Operation op = dbwsAdapter.getOperation(invocation.getName());
        org.eclipse.persistence.internal.oxm.schema.model.Element invocationElement = (org.eclipse.persistence.internal.oxm.schema.model.Element)dbwsAdapter.getExtendedSchema().getTopLevelElements().get(invocation.getName());
        String typeName = invocationElement.getType();
        int idx = typeName.indexOf(58);
        if (idx != -1) {
            typeName = typeName.substring(idx + 1);
        }
        if ((complexType = (ComplexType)dbwsAdapter.getExtendedSchema().getTopLevelComplexTypes().get(typeName)).getSequence() != null) {
            for (org.eclipse.persistence.internal.oxm.schema.model.Element e : complexType.getSequence().getOrderedElements()) {
                QName argQName;
                Class<?> clz;
                String argName = e.getName();
                Object argValue = invocation.getParameter(argName);
                String argType = e.getType();
                if (argType == null) continue;
                String argTypePrefix = null;
                String nameSpaceURI = null;
                idx = argType.indexOf(58);
                if (idx != -1) {
                    argTypePrefix = argType.substring(0, idx);
                    argType = argType.substring(idx + 1);
                    nameSpaceURI = dbwsAdapter.getSchema().getNamespaceResolver().resolveNamespacePrefix(argTypePrefix);
                }
                if ((clz = Util.SCHEMA_2_CLASS.get(argQName = argTypePrefix == null ? new QName(nameSpaceURI, argType) : new QName(nameSpaceURI, argType, argTypePrefix))) == null) continue;
                argValue = ((XMLConversionManager)dbwsAdapter.getOXSession().getDatasourcePlatform().getConversionManager()).convertObject(argValue, clz, argQName);
                invocation.setParameter(argName, argValue);
            }
        }
        Object result = null;
        try {
            result = op.invoke(dbwsAdapter, invocation);
            if (result instanceof ValueObject) {
                result = ((ValueObject)result).value;
            }
        }
        catch (EclipseLinkException ele) {
            try {
                response = this.responseWriter.generateResponse(op, ele);
            }
            catch (SOAPException e) {
                SOAPFault soapFault = null;
                try {
                    soapFault = ProviderHelper.getSOAPFactory().createFault("SOAPMessage response error - " + e.getMessage(), new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"));
                }
                catch (SOAPException se) {
                    // empty catch block
                }
                throw new SOAPFaultException(soapFault);
            }
        }
        try {
            response = this.responseWriter.generateResponse(op, result);
        }
        catch (Exception e) {
            SOAPFault soapFault = null;
            try {
                soapFault = ProviderHelper.getSOAPFactory().createFault("SOAPMessage response format error - " + e.getMessage(), new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"));
            }
            catch (SOAPException se) {
                // empty catch block
            }
            throw new SOAPFaultException(soapFault);
        }
        return response;
    }

    public void destroy() {
        this.logoutSessions();
        this.responseWriter = null;
        try {
            this.xrSchemaStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.xrSchemaStream = null;
        this.parentClassLoader = null;
        this.xrService.setXMLContext(null);
        this.xrService = null;
    }

    public XRServiceAdapter buildService(XRServiceModel xrServiceModel) {
        this.xrService = new DBWSAdapter();
        DBWSAdapter dbws = (DBWSAdapter)this.xrService;
        dbws.setName(xrServiceModel.getName());
        dbws.setSessionsFile(xrServiceModel.getSessionsFile());
        dbws.setOperations(xrServiceModel.getOperations());
        this.initializeService(this.parentClassLoader, this.xrSchemaStream);
        return dbws;
    }

    public static SOAPElement getSOAPBodyElement(SOAPMessage message) throws SOAPException {
        NodeList nodes = message.getSOAPPart().getEnvelope().getBody().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof SOAPBodyElement)) continue;
            return (SOAPElement)node;
        }
        return null;
    }

    private static TransformerFactory getTransformerFactory() {
        return LazyTransformerFactorySingleton.getInstance();
    }

    private static SOAPFactory getSOAPFactory() {
        return LazySOAPFactorySingleton.getInstance();
    }

    private static class LazySOAPFactorySingleton {
        static SOAPFactory sf = null;

        private LazySOAPFactorySingleton() {
        }

        static SOAPFactory getInstance() {
            return sf;
        }

        static {
            try {
                sf = SOAPFactory.newInstance();
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        }
    }

    private static class LazyTransformerFactorySingleton {
        static TransformerFactory tf = TransformerFactory.newInstance();

        private LazyTransformerFactorySingleton() {
        }

        static TransformerFactory getInstance() {
            return tf;
        }
    }
}

