/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.search.filter.AbstractAttributeFilter;
import org.eclipse.rmf.reqif10.search.filter.IFilter;

public abstract class AbstractTextFilter
extends AbstractAttributeFilter {
    public static final ImmutableSet<IFilter.Operator> SUPPORTED_OPERATORS = Sets.immutableEnumSet((Enum)IFilter.Operator.EQUALS, (Enum[])new IFilter.Operator[]{IFilter.Operator.NOT_EQUALS, IFilter.Operator.CONTAINS, IFilter.Operator.NOT_CONTAINS, IFilter.Operator.REGEXP, IFilter.Operator.IS_SET, IFilter.Operator.IS_NOT_SET});
    protected IFilter.Operator operator;
    protected String filterValue;
    protected AttributeDefinition attributeDefinition;
    protected InternalAttribute internalAttribute;
    protected boolean caseSensitive;
    protected boolean isInternal;

    public AbstractTextFilter(IFilter.Operator operator, String value, AttributeDefinition attributeDefinition, boolean caseSensitive) {
        this(operator, value, null, attributeDefinition, caseSensitive);
        this.isInternal = false;
        if (attributeDefinition == null) {
            throw new IllegalArgumentException("AttributeDefinition can not be null");
        }
    }

    public AbstractTextFilter(IFilter.Operator operator, String value, InternalAttribute internalFeature, boolean caseSensitive) {
        this(operator, value, internalFeature, null, caseSensitive);
        this.isInternal = true;
        if (internalFeature == null) {
            throw new IllegalArgumentException("AttributeDefinition can not be null");
        }
    }

    protected AbstractTextFilter(IFilter.Operator operator, String value, InternalAttribute internalFeature, AttributeDefinition attributeDefinition, boolean caseSensitive) {
        if (!this.getSupportedOperators().contains((Object)operator)) {
            throw new IllegalArgumentException("This filter does not support the " + operator.toString() + " operation");
        }
        if (value == null && operator != IFilter.Operator.IS_SET && operator != IFilter.Operator.IS_NOT_SET) {
            throw new IllegalArgumentException("Value can not be null");
        }
        if (internalFeature != null && attributeDefinition == null) {
            this.isInternal = true;
        } else if (attributeDefinition != null && internalFeature == null) {
            this.isInternal = false;
        } else {
            throw new IllegalArgumentException("internalFeature and attribute definition can not be null or set at the same time");
        }
        this.operator = operator;
        this.filterValue = value == null ? "" : value;
        this.internalAttribute = internalFeature;
        this.attributeDefinition = attributeDefinition;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean match(SpecElementWithAttributes element) {
        if (this.operator == IFilter.Operator.IS_SET || this.operator == IFilter.Operator.IS_NOT_SET) {
            return super.match(element);
        }
        String theValue = this.isInternal ? this.getInternalAttributeValue(element) : this.getAttributeValue(element);
        if (theValue == null) {
            theValue = this.getDefaultValue(element);
        }
        if (theValue == null) {
            switch (this.operator) {
                case EQUALS: 
                case CONTAINS: {
                    return false;
                }
                case NOT_EQUALS: 
                case NOT_CONTAINS: {
                    return true;
                }
                case REGEXP: {
                    return this.matchRegexp("");
                }
            }
        }
        switch (this.operator) {
            case EQUALS: {
                return this.caseSensitive ? theValue.equals(this.filterValue) : theValue.equalsIgnoreCase(this.filterValue);
            }
            case NOT_EQUALS: {
                return this.caseSensitive ? !theValue.equals(this.filterValue) : !theValue.equalsIgnoreCase(this.filterValue);
            }
            case CONTAINS: {
                return this.caseSensitive ? theValue.contains(this.filterValue) : theValue.toLowerCase().contains(this.filterValue.toLowerCase());
            }
            case NOT_CONTAINS: {
                return this.caseSensitive ? !theValue.contains(this.filterValue) : !theValue.toLowerCase().contains(this.filterValue.toLowerCase());
            }
            case REGEXP: {
                return this.matchRegexp(theValue);
            }
        }
        return super.match(element);
    }

    protected abstract String getDefaultValue(SpecElementWithAttributes var1);

    @Override
    protected abstract String getInternalAttributeValue(SpecElementWithAttributes var1);

    protected abstract String getAttributeValue(SpecElementWithAttributes var1);

    @Override
    public abstract ImmutableSet<IFilter.Operator> getSupportedOperators();

    protected boolean matchRegexp(String value) {
        Pattern p = this.caseSensitive ? Pattern.compile(this.filterValue, 32) : Pattern.compile(this.filterValue, 34);
        Matcher matcher = p.matcher(value);
        return matcher.find();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public String getFilterValue1() {
        return this.filterValue;
    }

    @Override
    public String getFilterValue2() {
        return null;
    }

    @Override
    public IFilter.Operator getOperator() {
        return this.operator;
    }

    @Override
    public Object getAttribute() {
        return this.isInternal ? this.internalAttribute : this.attributeDefinition;
    }

    public static enum InternalAttribute {
        IDENTIFIER,
        DESC,
        LONG_NAME;

    }
}

