/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.types;

import javax.inject.Inject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.reachables.ReqcycleReachableHandler;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.types.IInjectedTypeChecker;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.exceptions.VisitableException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.uri.visitors.IVisitor;

public class ReqcycleTypeChecker
implements IInjectedTypeChecker {
    @Inject
    IReachableManager manager;
    @IInjectedTypeChecker.InjectValueName(type=IDataModel.class)
    String dataModel;
    @IInjectedTypeChecker.InjectValueName(type=Scope.class)
    String requirementScope;
    @IInjectedTypeChecker.InjectValueName(type=IRequirementType.class)
    String requirementType;
    @Inject
    IDataModelManager dataModelManager;

    public boolean apply(Reachable reachable) {
        ReqcycleReachableHandler handler = new ReqcycleReachableHandler();
        if (handler.handlesReachable(reachable)) {
            try {
                ReachableObject object = this.manager.getHandlerFromReachable(reachable).getFromReachable(reachable);
                IsRequirementTypeVisitor visitor = new IsRequirementTypeVisitor();
                object.getVisitable().accept((IVisitor)visitor);
                return visitor.getResult();
            }
            catch (IReachableHandlerException e) {
                e.printStackTrace();
            }
            catch (VisitableException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    class IsRequirementTypeVisitor
    implements IVisitor {
        boolean found = false;

        IsRequirementTypeVisitor() {
        }

        public void start(IAdaptable adaptable) {
        }

        public boolean visit(Object o, IAdaptable adaptable) {
            this.found = false;
            if (o instanceof AbstractElement) {
                AbstractElement type = (AbstractElement)o;
                this.found = true;
                if (ReqcycleTypeChecker.this.dataModel != null) {
                    String dataModelName = type.eClass().getEPackage().getName();
                    if (!dataModelName.equals(ReqcycleTypeChecker.this.dataModel)) {
                        this.found = false;
                    }
                    if (this.found && ReqcycleTypeChecker.this.requirementScope != null) {
                        this.found = false;
                        for (Scope s : type.getScopes()) {
                            EObject newObj;
                            if (s.eIsProxy() && s.eResource() != null && (newObj = EcoreUtil.resolve((EObject)s, (ResourceSet)s.eResource().getResourceSet())) instanceof Scope) {
                                s = (Scope)newObj;
                            }
                            this.found = ReqcycleTypeChecker.this.requirementScope.contains(":") ? ReqcycleTypeChecker.this.requirementScope.equals(String.valueOf(dataModelName) + "::" + s.getName()) : ReqcycleTypeChecker.this.requirementScope.equals(s.getName());
                        }
                    }
                    if (this.found && ReqcycleTypeChecker.this.requirementType != null) {
                        this.found = false;
                        String className = type.eClass().getName();
                        this.found = ReqcycleTypeChecker.this.requirementType.contains(":") ? ReqcycleTypeChecker.this.requirementType.equals(String.valueOf(dataModelName) + "::" + className) : className.equals(ReqcycleTypeChecker.this.requirementType);
                    }
                }
            }
            return this.found;
        }

        public void end(IAdaptable adaptable) {
        }

        boolean getResult() {
            return this.found;
        }
    }
}

