/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.jdt.traceability;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.polarsys.reqcycle.jdt.traceability.types.JDTType;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class JDTPreferences {
    private static final String JDT_TYPES_CONSTANT = "org.polarsys.reqcycle.jdt.traceability.jdtType";

    public static Map<String, TType> getPreferences() {
        IConfigurationManager manager = (IConfigurationManager)ZigguratInject.make(IConfigurationManager.class);
        Map map = manager.getSimpleConfiguration(null, null, JDT_TYPES_CONSTANT, false);
        if (map == null) {
            return new HashMap<String, TType>();
        }
        return new HashMap<String, TType>(Maps.transformValues((Map)map, (Function)new MapFunction()));
    }

    public static void savePreferences(Map<String, TType> map) {
        IConfigurationManager manager = (IConfigurationManager)ZigguratInject.make(IConfigurationManager.class);
        HashMap newMap = new HashMap(Maps.transformValues(map, (Function)Functions.toStringFunction()));
        try {
            manager.saveSimpleConfiguration(newMap, null, null, JDT_TYPES_CONSTANT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class MapFunction
    implements Function<Object, TType> {
        private MapFunction() {
        }

        public TType apply(Object o) {
            if (o instanceof String) {
                String string = (String)o;
                return new JDTType(string);
            }
            return null;
        }
    }
}

