/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.storage.savetriggers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.rdfxml.RDFXMLWriter;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.repositoryholders.SesameXMLRepositoryHolder;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.savetriggers.ISaveTrigger;

public class XMLSaveTrigger
implements ISaveTrigger {
    private final SesameXMLRepositoryHolder repositoryHolder;
    private final IProject project;

    public XMLSaveTrigger(SesameXMLRepositoryHolder repositoryHolder, IProject project) {
        this.project = project;
        this.repositoryHolder = repositoryHolder;
    }

    @Override
    public void doSave(RepositoryConnection connection) throws RepositoryException, RDFHandlerException, IOException, CoreException {
        IFile targetIFile = this.repositoryHolder.getTargetIFile(this.project);
        File targetFile = this.repositoryHolder.getTargetFile(this.project);
        BufferedOutputStream outstream = new BufferedOutputStream(new FileOutputStream(targetFile));
        try {
            connection.export((RDFHandler)new RDFXMLWriter((OutputStream)outstream), new Resource[0]);
        }
        finally {
            outstream.close();
        }
        targetIFile.refreshLocal(1, null);
    }
}

