/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.storage;

import com.google.common.collect.Collections2;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.storage.IStorageProvider;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.traceability.storage.sesame.exceptions.SesameStorageRuntimeException;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers.KindStorageHelper;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers.LinksStorageHelper;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers.ReachablesStorageHelper;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers.StorageHelpersProvider;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.internal.beans.LinkRef;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.savetriggers.ISaveTrigger;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.utils.Reachable2StorageURIFunction;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.Reachable;

public class SesameTraceabilityStorage
implements ITraceabilityStorage {
    private final String path;
    private final ISaveTrigger saveTrigger;
    private final RepositoryConnection connection;
    private StorageHelpersProvider helpers;
    private final IStorageProvider provider;
    @Inject
    IReachableCreator creator;

    public SesameTraceabilityStorage(IStorageProvider provider, String path, RepositoryConnection connection, ISaveTrigger saveTrigger) {
        this.provider = provider;
        this.path = path;
        this.connection = connection;
        this.saveTrigger = saveTrigger;
        this.helpers = new StorageHelpersProvider(connection);
    }

    private Iterable<Pair<Link, Reachable>> retrieveTraceability(ITraceabilityEngine.DIRECTION direction, URI extremityValue, Resource context) throws MalformedQueryException, QueryEvaluationException, URISyntaxException, RepositoryException {
        URI extremityPredicate = LinksStorageHelper.getDirectionPredicate(direction);
        LinkedList<Pair<Link, Reachable>> result = new LinkedList<Pair<Link, Reachable>>();
        Collection<LinkRef> linkRefs = this.helpers.getLinksStorageHelper().getStoredLinkRefsByExtremity(extremityPredicate, extremityValue, context);
        for (LinkRef linkRef : linkRefs) {
            Link link = this.helpers.getLinksStorageHelper().getStoredLinkFromRef(linkRef, context);
            for (Reachable r : link.getTargets()) {
                Pair pair = new Pair((Object)link, (Object)r);
                result.add((Pair<Link, Reachable>)pair);
            }
        }
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public void dispose() {
        this.provider.notifyChanged("TOPIC_REQCYCLE_TRACEABILITY/DISPOSE", (Object)this);
        try {
            this.connection.close();
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to release sesame connection", e);
        }
    }

    public void startTransaction() {
        try {
            if (!this.connection.isActive()) {
                this.connection.begin();
            }
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to start transaction", e);
        }
    }

    public void commit() {
        try {
            this.connection.commit();
            this.provider.notifyChanged("TOPIC_REQCYCLE_TRACEABILITY/COMMIT", (Object)this);
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to commit current transaction", e);
        }
    }

    public void save() {
        try {
            if (this.saveTrigger != null) {
                this.saveTrigger.doSave(this.connection);
            }
            this.provider.notifyChanged("TOPIC_REQCYCLE_TRACEABILITY/SAVE", (Object)this);
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to save current state", e);
        }
        catch (OpenRDFException e) {
            throw new SesameStorageRuntimeException("Failed to save current state", e);
        }
        catch (IOException e) {
            throw new SesameStorageRuntimeException("Failed to save current state", e);
        }
        catch (CoreException e) {
            throw new SesameStorageRuntimeException("Failed to save current state", e);
        }
    }

    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to perform a rollback on the current transaction", e);
        }
    }

    public void clearInContainer(Reachable container) {
        try {
            URI uri = ReachablesStorageHelper.getURI(container);
            this.connection.clear(new Resource[]{uri});
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to remove all statements in container " + container, e);
        }
    }

    public void addOrUpdateUpwardRelationShip(TType ttype, Reachable traceaReachable, Reachable container, Reachable source, Reachable ... targets) {
        try {
            if (targets != null && targets.length > 0) {
                this.helpers.getLinksStorageHelper().storeLink(traceaReachable, ttype, source, targets, container);
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new SesameStorageRuntimeException("Failed to add new relationship", e);
        }
        catch (URISyntaxException e) {
            throw new SesameStorageRuntimeException("Failed to add new relationship", e);
        }
    }

    public void removeTraceabilityLink(Reachable r) {
        try {
            URI traceaUri = ReachablesStorageHelper.getURI(r);
            this.connection.remove((Resource)traceaUri, null, null, new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to commit current transaction", e);
        }
    }

    public Reachable getReachable(String strUri) {
        try {
            ValueFactory valueFactory = this.connection.getValueFactory();
            URI uri = valueFactory.createURI(strUri);
            return this.helpers.getReachablesStorageHelper().getStoredReachable(this.connection, uri, null);
        }
        catch (URISyntaxException e) {
            throw new SesameStorageRuntimeException("Failed to create reachable ", e);
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to create reachable ", e);
        }
        catch (QueryEvaluationException e) {
            throw new SesameStorageRuntimeException("Failed to create reachable ", e);
        }
        catch (MalformedQueryException e) {
            throw new SesameStorageRuntimeException("Failed to create reachable ", e);
        }
    }

    public Iterable<Pair<Link, Reachable>> getTraceability(Reachable reachable, ITraceabilityEngine.DIRECTION direction) {
        try {
            URI reacheableUri = ReachablesStorageHelper.getURI(reachable);
            return this.retrieveTraceability(direction, reacheableUri, null);
        }
        catch (MalformedQueryException e) {
            throw new SesameStorageRuntimeException("Failed to retrieve traceability links", e);
        }
        catch (QueryEvaluationException e) {
            throw new SesameStorageRuntimeException("Failed to retrieve traceability links", e);
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to retrieve traceability links", e);
        }
        catch (URISyntaxException e) {
            throw new SesameStorageRuntimeException("Failed to retrieve traceability links", e);
        }
    }

    public Iterable<Pair<Link, Reachable>> getAllTraceability(ITraceabilityEngine.DIRECTION direction) {
        try {
            return this.retrieveTraceability(direction, null, null);
        }
        catch (MalformedQueryException e) {
            throw new SesameStorageRuntimeException("Failed to retrieve traceability links", e);
        }
        catch (QueryEvaluationException e) {
            throw new SesameStorageRuntimeException("Failed to retrieve traceability links", e);
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to retrieve traceability links", e);
        }
        catch (URISyntaxException e) {
            throw new SesameStorageRuntimeException("Failed to retrieve traceability links", e);
        }
    }

    public Iterable<Reachable> getTraceabilityLinksContainedIn(Reachable reachable) {
        try {
            URI context = ReachablesStorageHelper.getURI(reachable);
            Collection<LinkRef> linkRefs = this.helpers.getLinksStorageHelper().getStoredLinkRefsByExtremity(null, null, (Resource)context);
            LinkedList<Reachable> result = new LinkedList<Reachable>();
            for (LinkRef linkRef : linkRefs) {
                URI uri = linkRef.getId();
                Reachable storedReachable = this.helpers.getReachablesStorageHelper().getStoredReachable(this.connection, uri, (Resource)context);
                result.add(storedReachable);
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to retrieve traceability links", e);
        }
        catch (QueryEvaluationException e) {
            throw new SesameStorageRuntimeException("Failed to retrieve traceability links", e);
        }
        catch (MalformedQueryException e) {
            throw new SesameStorageRuntimeException("Failed to retrieve traceability links", e);
        }
        catch (URISyntaxException e) {
            throw new SesameStorageRuntimeException("Failed to retrieve traceability links", e);
        }
    }

    public void removeUpwardRelationShip(TType kind, Reachable container, Reachable source, Reachable ... targets) {
        try {
            URI kindUri = KindStorageHelper.getURI(kind.getId());
            URI sourceUri = ReachablesStorageHelper.getURI(source);
            URI containerUri = container != null ? ReachablesStorageHelper.getURI(container) : null;
            Collection targetValues = Collections2.transform(Arrays.asList(targets), new Reachable2StorageURIFunction());
            this.helpers.getLinksStorageHelper().removeStoredLinks(kindUri, sourceUri, containerUri, targetValues);
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to retreive traceability links", e);
        }
        catch (MalformedQueryException e) {
            throw new SesameStorageRuntimeException("Failed to retreive traceability links", e);
        }
        catch (QueryEvaluationException e) {
            throw new SesameStorageRuntimeException("Failed to retreive traceability links", e);
        }
    }

    public void updateRelationShip(Link oldLink, Link newLink, ITraceabilityEngine.DIRECTION direction) {
    }

    public void addUpdateProperty(Reachable reachable, String key, String value) {
        try {
            URI owner = ReachablesStorageHelper.getURI(reachable);
            this.helpers.getPropertiesStorageHelper().addOrUpdateProperty(owner, key, value, new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to add or update property", e);
        }
    }

    public void removeProperty(Reachable reachable, String key) {
        try {
            URI owner = ReachablesStorageHelper.getURI(reachable);
            this.helpers.getPropertiesStorageHelper().deleteStoredProperty(owner, key, null);
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to delete property: " + key, e);
        }
        catch (UpdateExecutionException e) {
            throw new SesameStorageRuntimeException("Failed to delete property: " + key, e);
        }
        catch (MalformedQueryException e) {
            throw new SesameStorageRuntimeException("Failed to delete property: " + key, e);
        }
    }

    public String getProperty(Reachable reachable, String key) {
        try {
            URI owner = ReachablesStorageHelper.getURI(reachable);
            return this.helpers.getPropertiesStorageHelper().getStoredProperty(owner, key, null);
        }
        catch (RepositoryException e) {
            throw new SesameStorageRuntimeException("Failed to get property: " + key, e);
        }
        catch (QueryEvaluationException e) {
            throw new SesameStorageRuntimeException("Failed to get property: " + key, e);
        }
        catch (MalformedQueryException e) {
            throw new SesameStorageRuntimeException("Failed to get property: " + key, e);
        }
    }
}

