package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link ImageInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableImageInfo.builder()}.
 */
@SuppressWarnings({"all", "deprecation", "removal"})
final class ImmutableImageInfo implements ImageInfo {
  private final String id;
  private final @Nullable String parent;
  private final @Nullable String comment;
  private final Date created;
  private final @Nullable String container;
  private final @Nullable ContainerConfig containerConfig;
  private final @Nullable String dockerVersion;
  private final @Nullable String author;
  private final ImageConfig config;
  private final String architecture;
  private final String os;
  private final Long size;
  private final @Nullable RootFs rootFs;

  private ImmutableImageInfo(
      String id,
      @Nullable String parent,
      @Nullable String comment,
      Date created,
      @Nullable String container,
      @Nullable ContainerConfig containerConfig,
      @Nullable String dockerVersion,
      @Nullable String author,
      ImageConfig config,
      String architecture,
      String os,
      Long size,
      @Nullable RootFs rootFs) {
    this.id = id;
    this.parent = parent;
    this.comment = comment;
    this.created = created;
    this.container = container;
    this.containerConfig = containerConfig;
    this.dockerVersion = dockerVersion;
    this.author = author;
    this.config = config;
    this.architecture = architecture;
    this.os = os;
    this.size = size;
    this.rootFs = rootFs;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("Id")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code parent} attribute
   */
  @JsonProperty("Parent")
  @Deprecated
  @Override
  public @Nullable String parent() {
    return parent;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @JsonProperty("Comment")
  @Deprecated
  @Override
  public @Nullable String comment() {
    return comment;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("Created")
  @Override
  public Date created() {
    return created;
  }

  /**
   * @return The value of the {@code container} attribute
   */
  @JsonProperty("Container")
  @Deprecated
  @Override
  public @Nullable String container() {
    return container;
  }

  /**
   * @return The value of the {@code containerConfig} attribute
   */
  @JsonProperty("ContainerConfig")
  @Deprecated
  @Override
  public @Nullable ContainerConfig containerConfig() {
    return containerConfig;
  }

  /**
   * @return The value of the {@code dockerVersion} attribute
   */
  @JsonProperty("DockerVersion")
  @Deprecated
  @Override
  public @Nullable String dockerVersion() {
    return dockerVersion;
  }

  /**
   * @return The value of the {@code author} attribute
   */
  @JsonProperty("Author")
  @Deprecated
  @Override
  public @Nullable String author() {
    return author;
  }

  /**
   * @return The value of the {@code config} attribute
   */
  @JsonProperty("Config")
  @Override
  public ImageConfig config() {
    return config;
  }

  /**
   * @return The value of the {@code architecture} attribute
   */
  @JsonProperty("Architecture")
  @Override
  public String architecture() {
    return architecture;
  }

  /**
   * @return The value of the {@code os} attribute
   */
  @JsonProperty("Os")
  @Override
  public String os() {
    return os;
  }

  /**
   * @return The value of the {@code size} attribute
   */
  @JsonProperty("Size")
  @Override
  public Long size() {
    return size;
  }

  /**
   * @return The value of the {@code rootFs} attribute
   */
  @JsonProperty("RootFS")
  @Override
  public @Nullable RootFs rootFs() {
    return rootFs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageInfo withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableImageInfo(
        newValue,
        this.parent,
        this.comment,
        this.created,
        this.container,
        this.containerConfig,
        this.dockerVersion,
        this.author,
        this.config,
        this.architecture,
        this.os,
        this.size,
        this.rootFs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#parent() parent} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parent (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageInfo withParent(@Nullable String value) {
    if (Objects.equals(this.parent, value)) return this;
    return new ImmutableImageInfo(
        this.id,
        value,
        this.comment,
        this.created,
        this.container,
        this.containerConfig,
        this.dockerVersion,
        this.author,
        this.config,
        this.architecture,
        this.os,
        this.size,
        this.rootFs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#comment() comment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageInfo withComment(@Nullable String value) {
    if (Objects.equals(this.comment, value)) return this;
    return new ImmutableImageInfo(
        this.id,
        this.parent,
        value,
        this.created,
        this.container,
        this.containerConfig,
        this.dockerVersion,
        this.author,
        this.config,
        this.architecture,
        this.os,
        this.size,
        this.rootFs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#created() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageInfo withCreated(Date value) {
    if (this.created == value) return this;
    Date newValue = Objects.requireNonNull(value, "created");
    return new ImmutableImageInfo(
        this.id,
        this.parent,
        this.comment,
        newValue,
        this.container,
        this.containerConfig,
        this.dockerVersion,
        this.author,
        this.config,
        this.architecture,
        this.os,
        this.size,
        this.rootFs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#container() container} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for container (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageInfo withContainer(@Nullable String value) {
    if (Objects.equals(this.container, value)) return this;
    return new ImmutableImageInfo(
        this.id,
        this.parent,
        this.comment,
        this.created,
        value,
        this.containerConfig,
        this.dockerVersion,
        this.author,
        this.config,
        this.architecture,
        this.os,
        this.size,
        this.rootFs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#containerConfig() containerConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for containerConfig (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageInfo withContainerConfig(@Nullable ContainerConfig value) {
    if (this.containerConfig == value) return this;
    return new ImmutableImageInfo(
        this.id,
        this.parent,
        this.comment,
        this.created,
        this.container,
        value,
        this.dockerVersion,
        this.author,
        this.config,
        this.architecture,
        this.os,
        this.size,
        this.rootFs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#dockerVersion() dockerVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dockerVersion (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageInfo withDockerVersion(@Nullable String value) {
    if (Objects.equals(this.dockerVersion, value)) return this;
    return new ImmutableImageInfo(
        this.id,
        this.parent,
        this.comment,
        this.created,
        this.container,
        this.containerConfig,
        value,
        this.author,
        this.config,
        this.architecture,
        this.os,
        this.size,
        this.rootFs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#author() author} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for author (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  @Deprecated
  public final ImmutableImageInfo withAuthor(@Nullable String value) {
    if (Objects.equals(this.author, value)) return this;
    return new ImmutableImageInfo(
        this.id,
        this.parent,
        this.comment,
        this.created,
        this.container,
        this.containerConfig,
        this.dockerVersion,
        value,
        this.config,
        this.architecture,
        this.os,
        this.size,
        this.rootFs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#config() config} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for config
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageInfo withConfig(ImageConfig value) {
    if (this.config == value) return this;
    ImageConfig newValue = Objects.requireNonNull(value, "config");
    return new ImmutableImageInfo(
        this.id,
        this.parent,
        this.comment,
        this.created,
        this.container,
        this.containerConfig,
        this.dockerVersion,
        this.author,
        newValue,
        this.architecture,
        this.os,
        this.size,
        this.rootFs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#architecture() architecture} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for architecture
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageInfo withArchitecture(String value) {
    String newValue = Objects.requireNonNull(value, "architecture");
    if (this.architecture.equals(newValue)) return this;
    return new ImmutableImageInfo(
        this.id,
        this.parent,
        this.comment,
        this.created,
        this.container,
        this.containerConfig,
        this.dockerVersion,
        this.author,
        this.config,
        newValue,
        this.os,
        this.size,
        this.rootFs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#os() os} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for os
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageInfo withOs(String value) {
    String newValue = Objects.requireNonNull(value, "os");
    if (this.os.equals(newValue)) return this;
    return new ImmutableImageInfo(
        this.id,
        this.parent,
        this.comment,
        this.created,
        this.container,
        this.containerConfig,
        this.dockerVersion,
        this.author,
        this.config,
        this.architecture,
        newValue,
        this.size,
        this.rootFs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#size() size} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for size
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageInfo withSize(Long value) {
    Long newValue = Objects.requireNonNull(value, "size");
    if (this.size.equals(newValue)) return this;
    return new ImmutableImageInfo(
        this.id,
        this.parent,
        this.comment,
        this.created,
        this.container,
        this.containerConfig,
        this.dockerVersion,
        this.author,
        this.config,
        this.architecture,
        this.os,
        newValue,
        this.rootFs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageInfo#rootFs() rootFs} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rootFs (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableImageInfo withRootFs(@Nullable RootFs value) {
    if (this.rootFs == value) return this;
    return new ImmutableImageInfo(
        this.id,
        this.parent,
        this.comment,
        this.created,
        this.container,
        this.containerConfig,
        this.dockerVersion,
        this.author,
        this.config,
        this.architecture,
        this.os,
        this.size,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableImageInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableImageInfo
        && equalsByValue((ImmutableImageInfo) another);
  }

  private boolean equalsByValue(ImmutableImageInfo another) {
    return id.equals(another.id)
        && Objects.equals(parent, another.parent)
        && Objects.equals(comment, another.comment)
        && created.equals(another.created)
        && Objects.equals(container, another.container)
        && Objects.equals(containerConfig, another.containerConfig)
        && Objects.equals(dockerVersion, another.dockerVersion)
        && Objects.equals(author, another.author)
        && config.equals(another.config)
        && architecture.equals(another.architecture)
        && os.equals(another.os)
        && size.equals(another.size)
        && Objects.equals(rootFs, another.rootFs);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code parent}, {@code comment}, {@code created}, {@code container}, {@code containerConfig}, {@code dockerVersion}, {@code author}, {@code config}, {@code architecture}, {@code os}, {@code size}, {@code rootFs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(parent);
    h += (h << 5) + Objects.hashCode(comment);
    h += (h << 5) + created.hashCode();
    h += (h << 5) + Objects.hashCode(container);
    h += (h << 5) + Objects.hashCode(containerConfig);
    h += (h << 5) + Objects.hashCode(dockerVersion);
    h += (h << 5) + Objects.hashCode(author);
    h += (h << 5) + config.hashCode();
    h += (h << 5) + architecture.hashCode();
    h += (h << 5) + os.hashCode();
    h += (h << 5) + size.hashCode();
    h += (h << 5) + Objects.hashCode(rootFs);
    return h;
  }

  /**
   * Prints the immutable value {@code ImageInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ImageInfo{"
        + "id=" + id
        + ", parent=" + parent
        + ", comment=" + comment
        + ", created=" + created
        + ", container=" + container
        + ", containerConfig=" + containerConfig
        + ", dockerVersion=" + dockerVersion
        + ", author=" + author
        + ", config=" + config
        + ", architecture=" + architecture
        + ", os=" + os
        + ", size=" + size
        + ", rootFs=" + rootFs
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ImageInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ImageInfo instance
   */
  public static ImmutableImageInfo copyOf(ImageInfo instance) {
    if (instance instanceof ImmutableImageInfo) {
      return (ImmutableImageInfo) instance;
    }
    return ImmutableImageInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableImageInfo ImmutableImageInfo}.
   * <pre>
   * ImmutableImageInfo.builder()
   *    .id(String) // required {@link ImageInfo#id() id}
   *    .parent(String | null) // nullable {@link ImageInfo#parent() parent}
   *    .comment(String | null) // nullable {@link ImageInfo#comment() comment}
   *    .created(Date) // required {@link ImageInfo#created() created}
   *    .container(String | null) // nullable {@link ImageInfo#container() container}
   *    .containerConfig(org.mandas.docker.client.messages.ContainerConfig | null) // nullable {@link ImageInfo#containerConfig() containerConfig}
   *    .dockerVersion(String | null) // nullable {@link ImageInfo#dockerVersion() dockerVersion}
   *    .author(String | null) // nullable {@link ImageInfo#author() author}
   *    .config(org.mandas.docker.client.messages.ImageConfig) // required {@link ImageInfo#config() config}
   *    .architecture(String) // required {@link ImageInfo#architecture() architecture}
   *    .os(String) // required {@link ImageInfo#os() os}
   *    .size(Long) // required {@link ImageInfo#size() size}
   *    .rootFs(org.mandas.docker.client.messages.RootFs | null) // nullable {@link ImageInfo#rootFs() rootFs}
   *    .build();
   * </pre>
   * @return A new ImmutableImageInfo builder
   */
  public static ImmutableImageInfo.Builder builder() {
    return new ImmutableImageInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableImageInfo ImmutableImageInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_CREATED = 0x2L;
    private static final long INIT_BIT_CONFIG = 0x4L;
    private static final long INIT_BIT_ARCHITECTURE = 0x8L;
    private static final long INIT_BIT_OS = 0x10L;
    private static final long INIT_BIT_SIZE = 0x20L;
    private long initBits = 0x3fL;

    private String id;
    private String parent;
    private String comment;
    private Date created;
    private String container;
    private ContainerConfig containerConfig;
    private String dockerVersion;
    private String author;
    private ImageConfig config;
    private String architecture;
    private String os;
    private Long size;
    private RootFs rootFs;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ImageInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ImageInfo instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.id());
      @Nullable String parentValue = instance.parent();
      if (parentValue != null) {
        parent(parentValue);
      }
      @Nullable String commentValue = instance.comment();
      if (commentValue != null) {
        comment(commentValue);
      }
      this.created(instance.created());
      @Nullable String containerValue = instance.container();
      if (containerValue != null) {
        container(containerValue);
      }
      @Nullable ContainerConfig containerConfigValue = instance.containerConfig();
      if (containerConfigValue != null) {
        containerConfig(containerConfigValue);
      }
      @Nullable String dockerVersionValue = instance.dockerVersion();
      if (dockerVersionValue != null) {
        dockerVersion(dockerVersionValue);
      }
      @Nullable String authorValue = instance.author();
      if (authorValue != null) {
        author(authorValue);
      }
      this.config(instance.config());
      this.architecture(instance.architecture());
      this.os(instance.os());
      this.size(instance.size());
      @Nullable RootFs rootFsValue = instance.rootFs();
      if (rootFsValue != null) {
        rootFs(rootFsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#parent() parent} attribute.
     * @param parent The value for parent (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Parent")
    @Deprecated
    public final Builder parent(@Nullable String parent) {
      this.parent = parent;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#comment() comment} attribute.
     * @param comment The value for comment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Comment")
    @Deprecated
    public final Builder comment(@Nullable String comment) {
      this.comment = comment;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#created() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Created")
    public final Builder created(Date created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#container() container} attribute.
     * @param container The value for container (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Container")
    @Deprecated
    public final Builder container(@Nullable String container) {
      this.container = container;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#containerConfig() containerConfig} attribute.
     * @param containerConfig The value for containerConfig (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ContainerConfig")
    @Deprecated
    public final Builder containerConfig(@Nullable ContainerConfig containerConfig) {
      this.containerConfig = containerConfig;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#dockerVersion() dockerVersion} attribute.
     * @param dockerVersion The value for dockerVersion (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("DockerVersion")
    @Deprecated
    public final Builder dockerVersion(@Nullable String dockerVersion) {
      this.dockerVersion = dockerVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#author() author} attribute.
     * @param author The value for author (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Author")
    @Deprecated
    public final Builder author(@Nullable String author) {
      this.author = author;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#config() config} attribute.
     * @param config The value for config 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Config")
    public final Builder config(ImageConfig config) {
      this.config = Objects.requireNonNull(config, "config");
      initBits &= ~INIT_BIT_CONFIG;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#architecture() architecture} attribute.
     * @param architecture The value for architecture 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Architecture")
    public final Builder architecture(String architecture) {
      this.architecture = Objects.requireNonNull(architecture, "architecture");
      initBits &= ~INIT_BIT_ARCHITECTURE;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#os() os} attribute.
     * @param os The value for os 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Os")
    public final Builder os(String os) {
      this.os = Objects.requireNonNull(os, "os");
      initBits &= ~INIT_BIT_OS;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#size() size} attribute.
     * @param size The value for size 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Size")
    public final Builder size(Long size) {
      this.size = Objects.requireNonNull(size, "size");
      initBits &= ~INIT_BIT_SIZE;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageInfo#rootFs() rootFs} attribute.
     * @param rootFs The value for rootFs (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("RootFS")
    public final Builder rootFs(@Nullable RootFs rootFs) {
      this.rootFs = rootFs;
      return this;
    }

    /**
     * Builds a new {@link ImmutableImageInfo ImmutableImageInfo}.
     * @return An immutable instance of ImageInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableImageInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableImageInfo(
          id,
          parent,
          comment,
          created,
          container,
          containerConfig,
          dockerVersion,
          author,
          config,
          architecture,
          os,
          size,
          rootFs);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      if ((initBits & INIT_BIT_CONFIG) != 0) attributes.add("config");
      if ((initBits & INIT_BIT_ARCHITECTURE) != 0) attributes.add("architecture");
      if ((initBits & INIT_BIT_OS) != 0) attributes.add("os");
      if ((initBits & INIT_BIT_SIZE) != 0) attributes.add("size");
      return "Cannot build ImageInfo, some of required attributes are not set " + attributes;
    }
  }
}
