/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.views.TimeAlignViewsAction;
import org.eclipse.tracecompass.internal.tmf.ui.views.TmfAlignmentSynchronizer;
import org.eclipse.tracecompass.tmf.core.component.ITmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.ITmfAllowMultiple;
import org.eclipse.tracecompass.tmf.ui.views.ITmfPinnable;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.NewTmfViewAction;
import org.eclipse.tracecompass.tmf.ui.views.PinTmfViewAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public abstract class TmfView
extends ViewPart
implements ITmfComponent {
    private static final TmfAlignmentSynchronizer TIME_ALIGNMENT_SYNCHRONIZER = TmfAlignmentSynchronizer.getInstance();
    private final String fName;
    private Composite fParentComposite;
    private ControlAdapter fControlListener;
    protected PinTmfViewAction fPinAction;
    private static TimeAlignViewsAction fAlignViewsAction;
    private IAction fSaveAction;
    public static final String VIEW_ID_SEPARATOR = ":";

    public TmfView(String viewName) {
        this.fName = viewName;
        TmfSignalManager.register((Object)((Object)this));
    }

    public void dispose() {
        TmfSignalManager.deregister((Object)((Object)this));
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().removeAll();
        bars.getMenuManager().removeAll();
        super.dispose();
    }

    public String getName() {
        return this.fName;
    }

    public void broadcast(TmfSignal signal) {
        TmfSignalManager.dispatchSignal((TmfSignal)signal);
    }

    public void broadcastAsync(TmfSignal signal) {
        TmfSignalManager.dispatchSignalAsync((TmfSignal)signal);
    }

    public boolean isPinned() {
        return this.fPinAction != null && this.fPinAction.isPinned();
    }

    protected void contributePinActionToToolBar() {
        if (this.fPinAction == null && this instanceof ITmfPinnable) {
            this.fPinAction = new PinTmfViewAction((ITmfPinnable)((Object)this));
            IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
            toolBarManager.add((IContributionItem)new Separator("pin.group"));
            toolBarManager.add((IAction)this.fPinAction);
        }
    }

    public void createPartControl(Composite parent) {
        IAction saveAction;
        this.fParentComposite = parent;
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        if (this instanceof ITmfAllowMultiple) {
            this.contributeNewViewActionToLocalMenu(menuManager);
        }
        if ((saveAction = this.fSaveAction) == null) {
            this.fSaveAction = saveAction = this.createSaveAction();
        }
        if (saveAction != null) {
            menuManager.add((IContributionItem)new Separator());
            menuManager.add(saveAction);
            menuManager.add((IContributionItem)new Separator());
        }
        if (this instanceof ITmfTimeAligned) {
            TmfView.contributeAlignViewsActionToLocalMenu(menuManager);
            this.fControlListener = new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    e.display.asyncExec(() -> TIME_ALIGNMENT_SYNCHRONIZER.handleViewResized(TmfView.this));
                }
            };
            parent.addControlListener((ControlListener)this.fControlListener);
            this.getSite().getPage().addPartListener(new IPartListener(){

                public void partOpened(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                    if (part == TmfView.this && TmfView.this.fControlListener != null && !TmfView.this.fParentComposite.isDisposed()) {
                        TmfView.this.fParentComposite.removeControlListener((ControlListener)TmfView.this.fControlListener);
                        TmfView.this.fControlListener = null;
                        TmfView.this.getSite().getPage().removePartListener((IPartListener)this);
                        TIME_ALIGNMENT_SYNCHRONIZER.handleViewClosed(TmfView.this);
                    }
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partActivated(IWorkbenchPart part) {
                }
            });
        }
        if (!menuManager.isEmpty()) {
            menuManager.add((IContributionItem)new Separator("additions"));
        }
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("additions"));
        if (this instanceof ITmfPinnable) {
            this.contributePinActionToToolBar();
        }
    }

    protected @Nullable IAction createSaveAction() {
        return null;
    }

    private void contributeNewViewActionToLocalMenu(IMenuManager menuManager) {
        if (!menuManager.isEmpty()) {
            menuManager.add((IContributionItem)new Separator());
        }
        if (this instanceof ITmfPinnable) {
            MenuManager newViewMenu = new MenuManager(MessageFormat.format(Messages.TmfView_NewViewActionText, this.getTitle()));
            newViewMenu.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/new_view.png"));
            newViewMenu.setRemoveAllWhenShown(true);
            newViewMenu.addMenuListener((IMenuListener)new IMenuListener2(){

                /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                public void menuAboutToShow(IMenuManager mgr) {
                    @NonNull Set openedTraces = TmfTraceManager.getInstance().getOpenedTraces();
                    ITmfTrace activeTrace = ((ITmfPinnable)((Object)TmfView.this)).getTrace();
                    if (activeTrace != null) {
                        mgr.add((IAction)new NewTmfViewAction(TmfView.this, activeTrace, true));
                        mgr.add((IContributionItem)new Separator());
                    }
                    for (ITmfTrace trace : openedTraces) {
                        mgr.add((IAction)new NewTmfViewAction(TmfView.this, trace));
                    }
                    mgr.add((IContributionItem)new Separator());
                    mgr.add((IAction)new NewTmfViewAction(TmfView.this, null));
                }

                public void menuAboutToHide(IMenuManager manager) {
                    manager.removeAll();
                }
            });
            menuManager.add((IContributionItem)newViewMenu);
        } else {
            NewTmfViewAction action = new NewTmfViewAction(this);
            menuManager.add((IAction)action);
        }
    }

    private static void contributeAlignViewsActionToLocalMenu(IMenuManager menuManager) {
        if (fAlignViewsAction == null) {
            fAlignViewsAction = new TimeAlignViewsAction();
        }
        if (!menuManager.isEmpty()) {
            menuManager.add((IContributionItem)new Separator());
        }
        menuManager.add((IAction)fAlignViewsAction);
    }

    public Composite getParentComposite() {
        return this.fParentComposite;
    }

    protected @NonNull String getViewId() {
        IViewSite viewSite = this.getViewSite();
        String secondaryId = viewSite.getSecondaryId();
        if (secondaryId == null) {
            return String.valueOf(viewSite.getId());
        }
        return viewSite.getId() + VIEW_ID_SEPARATOR + secondaryId;
    }
}

