/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.cli;

import java.util.List;
import java.util.Optional;
import org.eclipse.passage.lic.cli.Option;
import org.eclipse.passage.lic.cli.TheOtherSide;

final class Options<K extends Option.Key, D extends Enum<?>> {
    private final List<Option<K, D>> options;
    private final TheOtherSide communication;

    Options(List<Option<K, D>> options, TheOtherSide communication) {
        this.options = options;
        this.communication = communication;
    }

    Option<K, D> promptAndPick() {
        while (true) {
            this.options.forEach(option -> this.communication.prompt(option.documentation()));
            String key = this.communication.input().trim();
            Optional<Option<K, D>> option2 = this.findOption(key);
            if (option2.isPresent()) {
                return option2.get();
            }
            this.communication.prompt(String.format("No option has been found for key [%s]", key));
        }
    }

    private Optional<Option<K, D>> findOption(String request) {
        if (request.length() != 1) {
            return Optional.empty();
        }
        char key = request.charAt(0);
        return this.options.stream().filter(op -> op.key().symbol() == key).findAny();
    }

    List<Option<K, D>> options() {
        return this.options;
    }
}

